/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemArc;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.geom.Arc2D;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class ArcStyleParameter
extends CanvasParameter {
    private static String name = "style";
    private static String defValue = "arc";
    private int newValue = 0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-style".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        if (swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            String arcType = null;
            switch (arc2D.getArcType()) {
                case 2: {
                    arcType = "pie";
                    break;
                }
                case 1: {
                    arcType = "chord";
                    break;
                }
                case 0: {
                    arcType = "arc";
                }
            }
            return TclString.newInstance((String)arcType);
        }
        throw new TclException(interp, "shape not arc");
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        if (arg.toString().startsWith("pie")) {
            this.newValue = 2;
        } else if (arg.toString().startsWith("cho")) {
            this.newValue = 1;
        } else if (arg.toString().equals("arc")) {
            this.newValue = 0;
        }
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape == null) {
            return;
        }
        if (swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            arc2D.setArcType(this.newValue);
        }
    }
}

