/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ImageParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.TreeMap;

public class ItemImage
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new ImageParameter(), new TagsParameter(), new StateParameter(), new TransformerParameter(), new NodeParameter()};
    static Map parameterMap = new TreeMap();
    BufferedImage bufferedImage;

    ItemImage(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[2];
    }

    public void setImage(BufferedImage newImage) {
        this.bufferedImage = newImage;
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }

    public boolean hitShape(double x1, double y1) {
        boolean hit = false;
        if (this.bufferedImage != null) {
            AffineTransform aT = new AffineTransform();
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                aT.setTransform(shapeTransform);
            }
            double x = this.storeCoords[0];
            double y = this.storeCoords[1];
            aT.rotate(this.rotate, x, y);
            double width = this.bufferedImage.getWidth();
            double height = this.bufferedImage.getHeight();
            Rectangle2D.Double rf1 = new Rectangle2D.Double(x, y, width, height);
            Rectangle2D rf1d = aT.createTransformedShape(rf1).getBounds2D();
            this.shape = rf1d;
            hit = this.shape.contains(x1, y1);
        }
        return hit;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 2) {
            throw new SwkException("wrong # coordinates: expected 2, got " + coords.length);
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, 2);
    }

    public void paintShape(Graphics2D g2) {
        AffineTransform aT = new AffineTransform();
        aT.translate((int)this.storeCoords[0], this.storeCoords[1]);
        if (this.bufferedImage != null) {
            g2.drawImage(this.bufferedImage, aT, null);
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "image";
    }

    static {
        ItemImage.initializeParameters(parameters, parameterMap);
    }
}

