/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.ProcessRunner;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.util.ShellUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/execv.c")
public final class Execv {
    private Execv() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulated by program execution, then interpretation stop. Process name is thus not set."}, parameterTypes={"string", "string array"}, returnType="'a")
    public static Value unix_execv(Value value, Value value2) throws Fail.Exception, Fatal.Exception, FalseExit {
        int n;
        Context context = CurrentContext.CONTEXT;
        FilesState filesState = context.getFilesState();
        int n2 = (int)value2.sizeValues();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = value2.get(n).asString();
        }
        stringArray[0] = filesState.getRealFile(value).getAbsolutePath();
        try {
            n = ProcessRunner.execute(filesState, ShellUtils.prepareArguments(stringArray), null, false);
            return Sys.caml_sys_exit(Value.createLong(n));
        }
        catch (FalseExit falseExit) {
            throw falseExit;
        }
        catch (InterruptedException interruptedException) {
            Unix.fail("execv", interruptedException);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("execv", iOException);
        }
        return Value.UNIT;
    }
}

