/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.DataFormat;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class MarshalIntern
implements DataFormat {
    private MarshalIntern() {
    }

    public static Value inputVal(Context ctxt, DataInput in, boolean checkMagic) throws IOException, Fail.Exception, Fatal.Exception {
        assert (ctxt != null) : "null ctxt";
        assert (in != null) : "null in";
        if (checkMagic && IO.read32s(in) != -2070567234) {
            Fail.failWith("input_value: bad object");
        }
        long blockLen = IO.read32u(in);
        long numObjects = IO.read32u(in);
        long size32 = IO.read32u(in);
        long size64 = IO.read32u(in);
        ArrayList<Value> objTable = size32 != 0L ? new ArrayList<Value>(IntegerUtils.ensure32s(numObjects)) : null;
        Value dest = Value.createBlock(0, Value.UNIT);
        MarshalIntern.internRec(ctxt, in, dest, 0L, objTable);
        return dest.get0();
    }

    private static void internRec(Context ctxt, DataInput in, Value d, long w, List<Value> objTable) throws IOException, Fail.Exception, Fatal.Exception {
        assert (ctxt != null) : "null ctxt";
        assert (in != null) : "null in";
        assert (d != null) : "null d";
        int readBlockTag = -1;
        long readBlockSize = -1L;
        boolean readBlock = false;
        Value lastId = null;
        Value dest = null;
        long where = -1L;
        LinkedList<StackItem> stack = new LinkedList<StackItem>();
        stack.add(0, new StackItem(d, w, 1L, StackOperation.READ_ITEMS));
        block24: while (!stack.isEmpty()) {
            StackItem top = (StackItem)stack.get(0);
            dest = top.destValue;
            where = top.destIndex;
            StackOperation op = top.op;
            switch (op) {
                case FRESH_OID: {
                    if (lastId == null) {
                        lastId = ctxt.getCodeState().getCallback("CamlinternalOO.last_id");
                    }
                    if (lastId == null) continue block24;
                    Value id = lastId.get0();
                    dest.set(where, id);
                    lastId.set0(Value.createFromRawValue(id.getRawValue() + 2L));
                    continue block24;
                }
                case SHIFT: {
                    Value tmp = dest.get(where + top.arg);
                    if (tmp.isBlock() && tmp.getTag() == 249) {
                        tmp.setParent(dest.asBlock());
                    }
                    dest.set(where, tmp);
                    stack.remove(0);
                    continue block24;
                }
                case READ_ITEMS: {
                    top.destIndex++;
                    top.arg--;
                    if (top.arg == 0L) {
                        stack.remove(0);
                    }
                    Value v = null;
                    int code = IO.read8u(in);
                    switch (code) {
                        case 0: {
                            v = Value.createLong(IO.read8s(in));
                            break;
                        }
                        case 1: {
                            v = Value.createLong(IO.read16s(in));
                            break;
                        }
                        case 2: {
                            v = Value.createLong(IO.read32s(in));
                            break;
                        }
                        case 3: {
                            v = Value.createLong(IO.read64s(in));
                            break;
                        }
                        case 4: {
                            v = objTable.get(objTable.size() - IO.read8u(in));
                            break;
                        }
                        case 5: {
                            v = objTable.get(objTable.size() - IO.read16u(in));
                            break;
                        }
                        case 6: {
                            v = objTable.get(objTable.size() - IntegerUtils.ensure32s(IO.read32u(in)));
                            break;
                        }
                        case 8: {
                            long header = IO.read32s(in);
                            readBlockTag = BlockValue.tagFromHeader(header);
                            readBlockSize = BlockValue.wosizeFromHeader(header);
                            readBlock = true;
                            break;
                        }
                        case 19: {
                            long header = IO.read64s(in);
                            readBlockTag = BlockValue.tagFromHeader(header);
                            readBlockSize = BlockValue.wosizeFromHeader(header);
                            readBlock = true;
                            break;
                        }
                        case 9: {
                            v = MarshalIntern.readString(in, IO.read8u(in), objTable);
                            break;
                        }
                        case 10: {
                            v = MarshalIntern.readString(in, IntegerUtils.ensure32s(IO.read32u(in)), objTable);
                            break;
                        }
                        case 11: 
                        case 12: {
                            boolean bl;
                            if (code != 11) {
                                bl = true;
                            } else {
                                if (code != 12) {
                                    // empty if block
                                }
                                bl = false;
                            }
                            v = MarshalIntern.readDouble(in, bl, objTable);
                            break;
                        }
                        case 13: 
                        case 14: {
                            boolean bl;
                            if (code != 13) {
                                bl = true;
                            } else {
                                if (code != 14) {
                                    // empty if block
                                }
                                bl = false;
                            }
                            v = MarshalIntern.readDoubleArray(in, bl, IO.read8u(in), objTable);
                            break;
                        }
                        case 7: 
                        case 15: {
                            boolean bl;
                            if (code != 15) {
                                bl = true;
                            } else {
                                if (code != 7) {
                                    // empty if block
                                }
                                bl = false;
                            }
                            v = MarshalIntern.readDoubleArray(in, bl, IntegerUtils.ensure32s(IO.read32u(in)), objTable);
                            break;
                        }
                        case 16: {
                            long codeOfs = IO.read32s(in);
                            byte[] chkSum = new byte[16];
                            in.readFully(chkSum);
                            Value codeOffset = ctxt.getCodeState().resolveFragment(chkSum, codeOfs);
                            if (codeOffset == null) {
                                String msg = String.format("input_value: unknown code module %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X", chkSum[0], chkSum[1], chkSum[2], chkSum[3], chkSum[4], chkSum[5], chkSum[6], chkSum[7], chkSum[8], chkSum[9], chkSum[10], chkSum[11], chkSum[12], chkSum[13], chkSum[14], chkSum[15]);
                                Fail.failWith(msg);
                                break;
                            }
                            v = codeOffset;
                            break;
                        }
                        case 17: {
                            int infixOfs = IntegerUtils.ensure32s(IO.read32u(in));
                            stack.add(0, new StackItem(dest, where, infixOfs / 8, StackOperation.SHIFT));
                            stack.add(0, new StackItem(dest, where, 1L, StackOperation.READ_ITEMS));
                            continue block24;
                        }
                        case 18: {
                            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                            byte b = in.readByte();
                            while (b != 0) {
                                tmp.write(b);
                                b = in.readByte();
                            }
                            String id = EncodingUtils.convertBytesToString(tmp.toByteArray());
                            tmp.close();
                            CustomOperations ops = ctxt.getCodeState().findCustom(id);
                            if (ops == null) {
                                Fail.failWith("input_value: unknown custom block identifier");
                            }
                            CustomOperations.DeserializedValue dv = ops.deserialize(in);
                            if (objTable != null) {
                                objTable.add(dv.value);
                            }
                            v = dv.value;
                            break;
                        }
                        default: {
                            if (code >= 32 && code < 64) {
                                v = MarshalIntern.readString(in, code & 0x1F, objTable);
                                break;
                            }
                            if (code >= 64 && code < 128) {
                                v = Value.createLong(code & 0x3F);
                                break;
                            }
                            if (code >= 128) {
                                readBlockTag = code & 0xF;
                                readBlockSize = code >> 4 & 7;
                                readBlock = true;
                                break;
                            }
                            Fail.failWith("input_value: ill-formed message");
                            return;
                        }
                    }
                    if (readBlock) {
                        if (readBlockSize == 0L) {
                            v = ctxt.getCodeState().getAtom(readBlockTag);
                        } else {
                            v = Value.createBlock(readBlockTag, readBlockSize);
                            if (objTable != null) {
                                objTable.add(v);
                            }
                            if (readBlockTag == 248) {
                                stack.add(0, new StackItem(v, 2L, readBlockSize - 2L, StackOperation.READ_ITEMS));
                                stack.add(0, new StackItem(v, 1L, 1L, StackOperation.FRESH_OID));
                                stack.add(0, new StackItem(v, 0L, 2L, StackOperation.READ_ITEMS));
                            } else {
                                stack.add(0, new StackItem(v, 0L, readBlockSize, StackOperation.READ_ITEMS));
                            }
                        }
                        readBlock = false;
                    }
                    if (v.isBlock() && v.getTag() == 249) {
                        v.setParent(dest.asBlock());
                    }
                    dest.set(where, v);
                    continue block24;
                }
            }
            assert (false) : "should not happen";
        }
    }

    private static Value readString(DataInput in, int len, List<Value> objTable) throws IOException {
        assert (in != null) : "null in";
        assert (len >= 0) : "len should be >= 0";
        byte[] tmp = new byte[len];
        in.readFully(tmp);
        Value res = Value.createString(tmp);
        if (objTable != null) {
            objTable.add(res);
        }
        return res;
    }

    private static Value readDouble(DataInput in, boolean toSwap, List<Value> objTable) throws IOException {
        assert (in != null) : "null in";
        long doubleBits = IO.read64s(in);
        double dbl = Double.longBitsToDouble(toSwap ? Long.reverseBytes(doubleBits) : doubleBits);
        Value res = Value.createDouble(dbl);
        if (objTable != null) {
            objTable.add(res);
        }
        return res;
    }

    private static Value readDoubleArray(DataInput in, boolean toSwap, int len, List<Value> objTable) throws IOException {
        assert (in != null) : "null in";
        assert (len >= 0) : "len should be >= 0";
        Value res = Value.createDoubleArray(len);
        if (objTable != null) {
            objTable.add(res);
        }
        if (toSwap) {
            for (int i = 0; i < len; ++i) {
                long doubleBits = IO.read64s(in);
                res.setDouble(i, Double.longBitsToDouble(Long.reverseBytes(doubleBits)));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long doubleBits = IO.read64s(in);
                res.setDouble(i, Double.longBitsToDouble(doubleBits));
            }
        }
        return res;
    }

    private static final class StackItem {
        private final Value destValue;
        private long destIndex;
        private long arg;
        private final StackOperation op;

        StackItem(Value v, long w, long a, StackOperation o) {
            this.destValue = v;
            this.destIndex = w;
            this.arg = a;
            this.op = o;
        }
    }

    private static enum StackOperation {
        READ_ITEMS,
        FRESH_OID,
        SHIFT;

    }
}

