/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.chart.XYData;
import com.onemoonscientific.swank.chart.XYLineAndShapeComplete;
import com.onemoonscientific.swank.chart.XYPlotShape;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class ShapesvisibleParameter
extends CanvasParameter {
    boolean[] visible = new boolean[0];
    private static final String name = "shapesvisible";

    ShapesvisibleParameter() {
        CanvasParameter.addParameter((CanvasParameter)this);
    }

    public String getName() {
        return name;
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        TclObject[] visibleList = TclList.getElements((Interp)interp, (TclObject)arg);
        if (visibleList.length == 0) {
            throw new TclException(interp, "bad visible value, must be \"value1 value2 ...\"");
        }
        boolean[] visibleTemp = new boolean[visibleList.length];
        for (int i = 0; i < visibleList.length; ++i) {
            visibleTemp[i] = TclBoolean.get((Interp)interp, (TclObject)visibleList[i]);
        }
        this.visible = visibleTemp;
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        boolean[] shapesVisible;
        XYLineAndShapeComplete xyShape = (XYLineAndShapeComplete)swkShape;
        XYPlot plot = xyShape.plot;
        TclObject result = TclList.newInstance();
        int nDatasets = plot.getDatasetCount();
        int j = 0;
        for (boolean bValue : shapesVisible = xyShape.getShapesVisible()) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclBoolean.newInstance((boolean)bValue));
        }
        for (int iData = 0; iData < nDatasets; ++iData) {
            XYItemRenderer renderer = ((XYPlotShape)swkShape).plot.getRenderer(iData);
            if (renderer == null) {
                renderer = ((XYPlotShape)swkShape).plot.getRenderer();
            }
            if (renderer instanceof XYLineAndShapeRenderer) {
                XYData data = (XYData)plot.getDataset(iData);
                if (data == null) continue;
                int nSeries = data.getSeriesCount();
                for (int i = 0; i < nSeries; ++i) {
                    Boolean sVisible = ((XYLineAndShapeRenderer)renderer).getSeriesShapesVisible(i);
                    boolean bValue = true;
                    if (sVisible != null) {
                        bValue = sVisible;
                    }
                    TclList.append((Interp)interp, (TclObject)result, (TclObject)TclBoolean.newInstance((boolean)bValue));
                    ++j;
                }
                continue;
            }
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclBoolean.newInstance((boolean)false));
        }
        return result;
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape instanceof XYLineAndShapeComplete) {
            XYLineAndShapeComplete xyShape = (XYLineAndShapeComplete)swkShape;
            xyShape.setShapesVisible(this.visible);
        }
    }
}

