/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class FinalizersState {
    private static final Field REFERENT = FinalizersState.initReferent();
    private final Context context;
    private final ReferenceQueue<BlockValue> unreachable;
    private final List<PhantomReference<BlockValue>> references;
    private final Map<Long, List<Infos>> infos;

    FinalizersState(Context context) {
        assert (context != null) : "null ctxt";
        this.context = context;
        this.unreachable = new ReferenceQueue();
        this.references = new LinkedList<PhantomReference<BlockValue>>();
        this.infos = new HashMap<Long, List<Infos>>();
    }

    private static Field initReferent() {
        Field field;
        try {
            field = Reference.class.getDeclaredField("referent");
            field.setAccessible(true);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    public synchronized void addFinalizer(BlockValue blockValue, Value value, CodeRunner codeRunner) {
        assert (blockValue != null) : "null b";
        assert (value != null) : "null f";
        assert (codeRunner != null) : "null runner";
        Long l = new Long(blockValue.getMagicNumber());
        List<Infos> list = this.infos.get(l);
        if (list != null) {
            list.add(new Infos(codeRunner, value));
        } else {
            LinkedList<Infos> linkedList = new LinkedList<Infos>();
            linkedList.add(new Infos(codeRunner, value));
            this.infos.put(l, linkedList);
            this.references.add(new PhantomReference<BlockValue>(blockValue, this.unreachable));
        }
    }

    public synchronized void addFinalizer(BlockValue blockValue) {
        assert (blockValue != null) : "null b";
        Long l = new Long(blockValue.getMagicNumber());
        List<Infos> list = this.infos.get(l);
        if (list == null) {
            this.infos.put(l, new LinkedList());
            this.references.add(new PhantomReference<BlockValue>(blockValue, this.unreachable));
        }
    }

    public synchronized void runFinalizers() throws FalseExit {
        Reference<BlockValue> reference = this.unreachable.poll();
        while (reference != null) {
            BlockValue blockValue;
            try {
                blockValue = (BlockValue)REFERENT.get(reference);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                blockValue = null;
            }
            if (blockValue != null) {
                Object object;
                BlockValue blockValue2 = (BlockValue)blockValue.duplicate();
                List<Infos> list = this.infos.remove(blockValue.getMagicNumber());
                if (blockValue2 instanceof AbstractCustomValue && (object = ((AbstractCustomValue)blockValue2).getCustomOperations()).isFinalized()) {
                    object.finalize(blockValue);
                }
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        Infos infos = (Infos)object.next();
                        this.runFinalizer(blockValue2, infos.function, infos.runner);
                    }
                }
                this.references.remove(reference);
            }
            reference = this.unreachable.poll();
        }
    }

    private synchronized void runFinalizer(BlockValue blockValue, Value value, CodeRunner codeRunner) throws FalseExit {
        assert (blockValue != null) : "null b";
        assert (value != null) : "null f";
        assert (codeRunner != null) : "null runner";
        Context context = codeRunner.getContext();
        try {
            codeRunner.callback(value, blockValue);
        }
        catch (Fail.Exception exception) {
            Value value2 = context.getCodeState().getGlobalData();
            String string = Misc.convertException(exception.asValue(value2), value2);
            Channel channel = context.getFilesState().getChannel(2);
            Channel.tryWrite(channel, "Error in finalizer: exception " + string);
        }
        catch (Fatal.Exception | OCamlJavaException exception) {
            Channel channel = context.getFilesState().getChannel(2);
            Channel.tryWrite(channel, "Error in finalizer: exception " + exception.getMessage());
        }
    }

    private static final class Infos {
        private final CodeRunner runner;
        private final Value function;

        private Infos(CodeRunner codeRunner, Value value) {
            assert (codeRunner != null) : "null r";
            assert (value != null) : "null f";
            this.runner = codeRunner;
            this.function = value;
        }
    }
}

