/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/read.c")
public final class Read {
    private Read() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "string", "int", "int"}, returnType="int")
    public static Value unix_read(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("read", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            channel.read(value2.getBytesForModification(), value3.asCastedInt(), value4.asCastedInt());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("read", iOException);
        }
        return value4;
    }
}

