/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJMenu;
import com.onemoonscientific.swank.SwkJMenuBar;
import com.onemoonscientific.swank.SwkJMenuWidgetCmd;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import javax.swing.JComponent;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJMenuBarWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "add"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ADD = 2;
    static boolean gotDefaults = false;
    Interp interp = null;

    SwkJMenuBarWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        this.interp = interp;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJMenuBar swkjmenubar = (SwkJMenuBar)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjmenubar.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjmenubar.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjmenubar.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjmenubar.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJMenuBar.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjmenubar.configure(interp, argv, 2);
                break;
            }
            case 2: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                this.addmenu(interp, swkjmenubar, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    public void addmenu(Interp interp, SwkJMenuBar swkjmenubar, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        String itemType = argv[2].toString();
        if (itemType.equals("cascade")) {
            String menuName = null;
            int j = 0;
            if ((argv.length - 3) % 2 != 0) {
                throw new TclNumArgsException(interp, 1, argv, "arguments not multiple of 2");
            }
            TclObject[] argNew = new TclObject[argv.length - 5];
            for (int i = 3; i < argv.length; i += 2) {
                if (argv[i].toString().equals("-menu")) {
                    menuName = argv[i + 1].toString();
                    continue;
                }
                argNew[j] = TclString.newInstance((String)argv[i].toString());
                argNew[j + 1] = TclString.newInstance((String)argv[i + 1].toString());
                j += 2;
            }
            TclObject tObj = (TclObject)Widgets.getWidget(interp, menuName);
            if (tObj == null) {
                SwkJMenu cascade = new Add().exec(swkjmenubar, menuName);
                interp.createCommand(menuName, (Command)new SwkJMenuWidgetCmd());
                tObj = ReflectObject.newInstance((Interp)interp, SwkJMenu.class, (Object)cascade);
                tObj.preserve();
                cascade.children = null;
                cascade = (SwkJMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
                cascade.configure(interp, argNew, 0);
                Widgets.addNewWidget(interp, menuName, tObj);
                cascade.setCreated(false);
            } else {
                SwkJMenu cascade = (SwkJMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
                new Add().exec(swkjmenubar, menuName, cascade);
                cascade.configure(interp, argNew, 0);
            }
        } else {
            throw new TclException(interp, "invalid menu option \"" + itemType + "\"");
        }
        swkjmenubar.revalidate();
    }

    class Add
    extends GetValueOnEventThread {
        SwkJMenuBar swkjmenubar = null;
        JComponent jcomp = null;
        String menuName = "";
        SwkWidget swkWidget = null;
        SwkJMenu cascade = null;

        Add() {
        }

        SwkJMenu exec(SwkJMenuBar swkjmenubar, String menuName) {
            this.swkjmenubar = swkjmenubar;
            this.menuName = menuName;
            this.execOnThread();
            return this.cascade;
        }

        SwkJMenu exec(SwkJMenuBar swkjmenubar, String menuName, SwkJMenu cascade) {
            this.swkjmenubar = swkjmenubar;
            this.cascade = cascade;
            this.menuName = menuName;
            this.execOnThread();
            return cascade;
        }

        public void run() {
            if (this.cascade == null) {
                this.cascade = new SwkJMenu(SwkJMenuBarWidgetCmd.this.interp, this.menuName, "Menu");
            }
            this.swkjmenubar.add(this.cascade);
        }
    }
}

