/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.BitmapParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;

public class ItemBitmap
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new BitmapParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    ImageIcon image;

    ItemBitmap(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[2];
    }

    public void setImageIcon(ImageIcon newImage) {
        this.image = newImage;
    }

    public ImageIcon getImageIcon() {
        return this.image;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 2) {
            throw new SwkException("wrong # coordinates: expected 2, got " + coords.length);
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, 2);
    }

    public void paintShape(Graphics2D g2) {
        if (this.image != null) {
            int imageWidth = this.image.getIconWidth();
            int imageHeight = this.image.getIconHeight();
            g2.drawImage(this.image.getImage(), (int)this.storeCoords[0] - imageWidth / 2, (int)this.storeCoords[1] - imageHeight / 2, null);
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "bitmap";
    }

    static {
        ItemBitmap.initializeParameters(parameters, parameterMap);
    }
}

