/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.ocamljava.runtime.util.EncodingUtils;

public final class InputStreamFromReader
extends InputStream {
    private final Reader source;

    public InputStreamFromReader(Reader reader) {
        assert (reader != null) : "null r";
        this.source = reader;
    }

    @Override
    public int read() throws IOException {
        return EncodingUtils.convertCharToByte((char)this.source.read());
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        char[] cArray = new char[byArray.length];
        int n = this.source.read(cArray);
        EncodingUtils.convertCharsToBytes(cArray, byArray, 0, n);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = this.source.read(cArray, n, n2);
        EncodingUtils.convertCharsToBytes(cArray, byArray, n, Math.min(n3, n2));
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.source.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.source.ready() ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void mark(int n) {
        try {
            this.source.mark(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }
}

