/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractLongBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeLongBlockValue
extends AbstractLongBlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private long[][] values;

    LargeLongBlockValue(int n, long l) {
        super(n, l);
        int n2 = (int)(l >> 31) + 1;
        int n3 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new long[n2][];
        for (int i = 0; i < n2 - 1; ++i) {
            this.values[i] = new long[Integer.MIN_VALUE];
        }
        this.values[n2 - 1] = new long[n3];
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        return this.values[n][n2];
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[0][n];
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        this.values[n][n2] = l2;
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        this.values[0][n] = l;
    }

    @Override
    public long sizeLongs() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long l) {
        int n;
        long[][] lArray = this.values;
        int n2 = (int)(l >> 31) + 1;
        int n3 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new long[n2][];
        for (n = 0; n < n2 - 1; ++n) {
            this.values[n] = new long[Integer.MIN_VALUE];
            for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                this.values[n][i] = lArray[n][i];
            }
        }
        this.values[n2 - 1] = new long[n3];
        for (n = 0; n < n3; ++n) {
            this.values[n2 - 1][n] = lArray[n2 - 1][n];
        }
    }

    @Override
    public void copy(BlockValue blockValue) {
        long l = Math.min(this.length, blockValue.sizeLongs());
        for (long i = 0L; i < l; ++i) {
            this.setRawLong(i, blockValue.getRawLong(i));
        }
    }

    @Override
    public LargeLongBlockValue duplicate() {
        long l = this.length;
        LargeLongBlockValue largeLongBlockValue = new LargeLongBlockValue(this.getTag(), l);
        for (long i = 0L; i < l; ++i) {
            largeLongBlockValue.setRawLong(i, this.getRawLong(i));
        }
        return largeLongBlockValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        int n = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < n2; ++i) {
            valueArray[n + i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getRawLong(i);
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getRawLong(i);
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        LargeLongBlockValue largeLongBlockValue = new LargeLongBlockValue(this.getTag(), l2);
        for (long i = 0L; i < l2; ++i) {
            largeLongBlockValue.setRawLong(i, this.getRawLong(i + l));
        }
        return largeLongBlockValue;
    }

    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (l2 < l) {
            for (long i = 0L; i < l3; ++i) {
                value.setRawLong(l2 + i, this.getRawLong(l + i));
            }
        } else {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value.setRawLong(l2 + i, this.getRawLong(l + i));
            }
        }
    }

    public int hashCode() {
        int n = 0;
        long[] lArray = this.values[0];
        int n2 = Math.min(32, lArray.length);
        for (int i = 0; i < n2; ++i) {
            n += (int)lArray[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof LargeLongBlockValue) {
            LargeLongBlockValue largeLongBlockValue = (LargeLongBlockValue)object;
            int n = this.values.length;
            int n2 = largeLongBlockValue.values.length;
            if (n == n) {
                int n3;
                for (n3 = 0; n3 < n && Arrays.equals(this.values[n3], largeLongBlockValue.values[n3]); ++n3) {
                }
                return n3 == n;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LargeLongBlockValue(");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.values[i].length;
            for (int j = 0; j < n2; ++j) {
                if (i + j != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.values[i][j]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long l) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(l));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.setRawLong(l, value.getRawValue());
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.setRawLong(n, value.getRawValue());
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.setRawLong(l, value.getRawValue());
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.getRawLong(n));
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.getRawLong(l));
    }

    @Override
    public long sizeDoubles() {
        return this.length;
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(n, (long)d);
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(l, (long)d);
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(n);
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(l);
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(n, (long)d);
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(l, (long)d);
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(n);
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(l);
    }

    @Override
    public void setRawLong0(long l) {
        this.setRawLong(0, l);
    }

    @Override
    public long getRawLong0() {
        return this.getRawLong(0);
    }

    @Override
    public void setGenericDouble0(double d) {
        this.setRawLong(0, (long)d);
    }

    @Override
    public double getGenericDouble0() {
        return this.getRawLong(0);
    }

    @Override
    public void setDouble0(double d) {
        this.setRawLong(0, (long)d);
    }

    @Override
    public double getDouble0() {
        return this.getRawLong(0);
    }

    @Override
    public void set0(Value value) {
        this.setRawLong(0, value.getRawValue());
    }

    @Override
    public Value get0() {
        return Value.createDouble(this.getRawLong(0));
    }

    @Override
    public void setRawLong1(long l) {
        this.setRawLong(1, l);
    }

    @Override
    public long getRawLong1() {
        return this.getRawLong(1);
    }

    @Override
    public void setGenericDouble1(double d) {
        this.setRawLong(1, (long)d);
    }

    @Override
    public double getGenericDouble1() {
        return this.getRawLong(1);
    }

    @Override
    public void setDouble1(double d) {
        this.setRawLong(1, (long)d);
    }

    @Override
    public double getDouble1() {
        return this.getRawLong(1);
    }

    @Override
    public void set1(Value value) {
        this.setRawLong(1, value.getRawValue());
    }

    @Override
    public Value get1() {
        return Value.createDouble(this.getRawLong(1));
    }

    @Override
    public void setRawLong2(long l) {
        this.setRawLong(2, l);
    }

    @Override
    public long getRawLong2() {
        return this.getRawLong(2);
    }

    @Override
    public void setGenericDouble2(double d) {
        this.setRawLong(2, (long)d);
    }

    @Override
    public double getGenericDouble2() {
        return this.getRawLong(2);
    }

    @Override
    public void setDouble2(double d) {
        this.setRawLong(2, (long)d);
    }

    @Override
    public double getDouble2() {
        return this.getRawLong(2);
    }

    @Override
    public void set2(Value value) {
        this.setRawLong(2, value.getRawValue());
    }

    @Override
    public Value get2() {
        return Value.createDouble(this.getRawLong(2));
    }

    @Override
    public void setRawLong3(long l) {
        this.setRawLong(3, l);
    }

    @Override
    public long getRawLong3() {
        return this.getRawLong(3);
    }

    @Override
    public void setGenericDouble3(double d) {
        this.setRawLong(3, (long)d);
    }

    @Override
    public double getGenericDouble3() {
        return this.getRawLong(3);
    }

    @Override
    public void setDouble3(double d) {
        this.setRawLong(3, (long)d);
    }

    @Override
    public double getDouble3() {
        return this.getRawLong(3);
    }

    @Override
    public void set3(Value value) {
        this.setRawLong(3, value.getRawValue());
    }

    @Override
    public Value get3() {
        return Value.createDouble(this.getRawLong(3));
    }

    @Override
    public void setRawLong4(long l) {
        this.setRawLong(4, l);
    }

    @Override
    public long getRawLong4() {
        return this.getRawLong(4);
    }

    @Override
    public void setGenericDouble4(double d) {
        this.setRawLong(4, (long)d);
    }

    @Override
    public double getGenericDouble4() {
        return this.getRawLong(4);
    }

    @Override
    public void setDouble4(double d) {
        this.setRawLong(4, (long)d);
    }

    @Override
    public double getDouble4() {
        return this.getRawLong(4);
    }

    @Override
    public void set4(Value value) {
        this.setRawLong(4, value.getRawValue());
    }

    @Override
    public Value get4() {
        return Value.createDouble(this.getRawLong(4));
    }

    @Override
    public void setRawLong5(long l) {
        this.setRawLong(5, l);
    }

    @Override
    public long getRawLong5() {
        return this.getRawLong(5);
    }

    @Override
    public void setGenericDouble5(double d) {
        this.setRawLong(5, (long)d);
    }

    @Override
    public double getGenericDouble5() {
        return this.getRawLong(5);
    }

    @Override
    public void setDouble5(double d) {
        this.setRawLong(5, (long)d);
    }

    @Override
    public double getDouble5() {
        return this.getRawLong(5);
    }

    @Override
    public void set5(Value value) {
        this.setRawLong(5, value.getRawValue());
    }

    @Override
    public Value get5() {
        return Value.createDouble(this.getRawLong(5));
    }

    @Override
    public void setRawLong6(long l) {
        this.setRawLong(6, l);
    }

    @Override
    public long getRawLong6() {
        return this.getRawLong(6);
    }

    @Override
    public void setGenericDouble6(double d) {
        this.setRawLong(6, (long)d);
    }

    @Override
    public double getGenericDouble6() {
        return this.getRawLong(6);
    }

    @Override
    public void setDouble6(double d) {
        this.setRawLong(6, (long)d);
    }

    @Override
    public double getDouble6() {
        return this.getRawLong(6);
    }

    @Override
    public void set6(Value value) {
        this.setRawLong(6, value.getRawValue());
    }

    @Override
    public Value get6() {
        return Value.createDouble(this.getRawLong(6));
    }

    @Override
    public void setRawLong7(long l) {
        this.setRawLong(7, l);
    }

    @Override
    public long getRawLong7() {
        return this.getRawLong(7);
    }

    @Override
    public void setGenericDouble7(double d) {
        this.setRawLong(7, (long)d);
    }

    @Override
    public double getGenericDouble7() {
        return this.getRawLong(7);
    }

    @Override
    public void setDouble7(double d) {
        this.setRawLong(7, (long)d);
    }

    @Override
    public double getDouble7() {
        return this.getRawLong(7);
    }

    @Override
    public void set7(Value value) {
        this.setRawLong(7, value.getRawValue());
    }

    @Override
    public Value get7() {
        return Value.createDouble(this.getRawLong(7));
    }
}

