/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.kernel.Disassembler;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.util.SignalSupport;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            ByteCodeParameters params;
            File currentDir = new File(".");
            try {
                currentDir = currentDir.getAbsoluteFile();
            }
            catch (Throwable t) {
                // empty catch block
            }
            ByteCodeParameters commandLineParams = Parameters.fromArray(args, PlatformUtils.isWindowPlatform() ? currentDir : null);
            ByteCodeParameters dialogParams = commandLineParams.showDialog() ? Parameters.fromDialog(commandLineParams) : null;
            ByteCodeParameters byteCodeParameters = params = dialogParams != null ? dialogParams : commandLineParams;
            if (params.showHelp()) {
                Parameters.printUsage(false, System.out);
                System.exit(0);
            } else if (params.showVersion()) {
                out.println("2.0-early-access7");
                System.exit(0);
            } else if (params.showSignalTest()) {
                SignalSupport.test(System.out);
                System.exit(0);
            }
            String filename = params.getFile();
            if (filename != null && !filename.equals("")) {
                Value res;
                RandomAccessInputStream bytecode = new RandomAccessInputStream(filename);
                Interpreter interpreter = new Interpreter(params, currentDir, bytecode, new CustomOperations[0]);
                bytecode.close();
                if (params.showDisassembled()) {
                    Disassembler.disassembleAll(interpreter.getContext(), System.out);
                }
                System.exit((res = interpreter.execute()) != null && res.isLong() ? res.asCastedInt() : 0);
            } else {
                out.println("no bytecode file specified.");
                System.exit(1);
            }
        }
        catch (Fatal.Exception fe) {
            out.println("fatal error: " + fe.getMessage());
            System.exit(1);
        }
        catch (IOException ioe) {
            out.println("i/o error: " + ioe.getMessage());
            System.exit(1);
        }
        catch (ParameterException cpe) {
            out.println("error: " + cpe.getMessage());
            System.exit(1);
        }
        catch (OCamlJavaException ce) {
            Throwable t = ce.getCause();
            if (!(t instanceof Fail.Exception) && !(t instanceof Fatal.Exception)) {
                err.println("error: " + ce.getMessage());
                ce.printStackTrace(err);
            }
            System.exit(1);
        }
        catch (Exception e) {
            err.println("internal error (Exception): " + e.getMessage());
            e.printStackTrace(err);
            System.exit(1);
        }
        catch (Throwable t) {
            err.println("internal error (Throwable): " + t.getMessage());
            t.printStackTrace(err);
            System.exit(1);
        }
    }
}

