/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicBool", source="")
public final class AtomicBool {
    private AtomicBool() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"bool"}, returnType="AtomicBool.t")
    public static Value ocamljava_atomicbool_make(Value initialValue) {
        return Value.createInstance(new AtomicBoolean(initialValue != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_compare_and_set(Value obj, Value expect, Value update) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        boolean res = inst.compareAndSet(expect != Value.FALSE, update != Value.FALSE);
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t"}, returnType="bool")
    public static Value ocamljava_atomicbool_get(Value obj) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        boolean res = inst.get();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_get_and_set(Value obj, Value newValue) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        boolean res = inst.getAndSet(newValue != Value.FALSE);
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="unit")
    public static Value ocamljava_atomicbool_lazy_set(Value obj, Value newValue) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        inst.lazySet(newValue != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="unit")
    public static Value ocamljava_atomicbool_set(Value obj, Value newValue) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        inst.set(newValue != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_weak_compare_and_set(Value obj, Value expect, Value update) {
        AtomicBoolean inst = (AtomicBoolean)obj.asCustom();
        boolean res = inst.weakCompareAndSet(expect != Value.FALSE, update != Value.FALSE);
        return res ? Value.TRUE : Value.FALSE;
    }
}

