/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.RejectedExecutionHandler;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadPoolExecutor", source="")
public final class ThreadPoolExecutor {
    private ThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static Value ocamljava_threadpoolexecutor_make(Value corePoolSize, Value maximumPoolSize, Value keepAliveTime, Value unit, Value handler) throws Fail.Exception {
        try {
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
            java.util.concurrent.ThreadPoolExecutor inst = new java.util.concurrent.ThreadPoolExecutor(corePoolSize.asInt32(), maximumPoolSize.asInt32(), keepAliveTime.asInt64(), TimeUnit.decode(unit), workQueue, threadFactory, RejectedExecutionHandler.decode(handler));
            return Value.createInstance(inst);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_await_termination(Value obj, Value timeout, Value unit) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        try {
            return inst.awaitTermination(timeout.asInt64(), TimeUnit.decode(unit)) ? Value.TRUE : Value.FALSE;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.await_termination");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_active_count(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt32(inst.getActiveCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_completed_task_count(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt64(inst.getCompletedTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_core_pool_size(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt32(inst.getCorePoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "TimeUnit.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_keep_alive_time(Value obj, Value unit) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt64(inst.getKeepAliveTime(TimeUnit.decode(unit)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_largest_pool_size(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt32(inst.getLargestPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_maximum_pool_size(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt32(inst.getMaximumPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_pool_size(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt32(inst.getPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="RejectedExecutionHandler.t")
    public static Value ocamljava_threadpoolexecutor_get_rejected_execution_handler(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return RejectedExecutionHandler.encode(inst.getRejectedExecutionHandler());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_task_count(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInt64(inst.getTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all(Value obj, Value tasks) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        try {
            return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l));
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_all");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time(Value obj, Value tasks, Value timeout, Value unit) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        try {
            return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l, timeout.asInt64(), TimeUnit.decode(unit)));
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_all_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any(Value obj, Value tasks) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        try {
            return inst.invokeAny(l);
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_any");
            return Value.UNIT;
        }
        catch (ExecutionException ee) {
            Fail.failWith("Concurrent.ThreadPoolExecutor.invoke_any");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time(Value obj, Value tasks, Value timeout, Value unit) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        try {
            return inst.invokeAny(l, timeout.asInt64(), TimeUnit.decode(unit));
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
        catch (ExecutionException ee) {
            Fail.failWith("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
        catch (TimeoutException te) {
            Runtime.raiseTimeout("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_shutdown(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return inst.isShutdown() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_terminated(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return inst.isTerminated() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_terminating(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return inst.isTerminating() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_core_pool_size(Value obj, Value corePoolSize) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        try {
            inst.setCorePoolSize(corePoolSize.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_core_pool_size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_keep_alive_time(Value obj, Value time, Value unit) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        try {
            inst.setKeepAliveTime(time.asInt64(), TimeUnit.decode(unit));
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_keep_alive_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_maximum_pool_size(Value obj, Value maximumPoolSize) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        try {
            inst.setMaximumPoolSize(maximumPoolSize.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_maximum_pool_size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "RejectedExecutionHandler.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_rejected_execution_handler(Value obj, Value handler) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        inst.setRejectedExecutionHandler(RejectedExecutionHandler.decode(handler));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_shutdown(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        inst.shutdown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return ThreadPoolExecutor.encodeRunnableList(inst.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Value ocamljava_threadpoolexecutor_submit(Value obj, Value task, Value value) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        try {
            return Value.createInstance(inst.submit(new FutureCallable(task, value)));
        }
        catch (Throwable t) {
            Fail.failWith("ThreadPoolExecutor.submit");
            return Value.UNIT;
        }
    }

    static List<Callable<Value>> decodeCallableList(Value l) {
        LinkedList<Callable<Value>> res = new LinkedList<Callable<Value>>();
        Value ptr = l;
        while (ptr.isBlock()) {
            res.add(new FutureCallable(ptr.get0(), Value.UNIT));
            ptr = ptr.get1();
        }
        return res;
    }

    static Value encodeFutureList(List<Future<Value>> l) {
        Value res = Value.EMPTY_LIST;
        ListIterator<Future<Value>> it = l.listIterator(l.size());
        while (it.hasPrevious()) {
            res = Value.createBlock(0, Value.createInstance(it.previous()), res);
        }
        return res;
    }

    static Value encodeRunnableList(List<Runnable> l) {
        Value res = Value.EMPTY_LIST;
        ListIterator<Runnable> it = l.listIterator(l.size());
        while (it.hasPrevious()) {
            Runnable elem = it.previous();
            if (!(elem instanceof RunnableFuture)) continue;
            res = Value.createBlock(0, Value.createInstance(elem), res);
        }
        return res;
    }
}

