/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas3D.CanvasParameter;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import java.util.Vector;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkShapeItemGet
implements Runnable {
    String tag = null;
    String parString = null;
    CanvasParameter[] parameters = null;
    SwkImageCanvas swkCanvas = null;
    SwkShape swkShape = null;
    Interp interp = null;

    public SwkShapeItemGet(Interp interp, SwkImageCanvas swkCanvas, String tag, String parString) {
        this.interp = interp;
        this.swkCanvas = swkCanvas;
        this.tag = tag;
        this.parString = parString;
    }

    public TclObject exec(boolean configStyle) throws TclException {
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception iE) {
            // empty catch block
        }
        if (this.swkShape == null) {
            throw new TclException(this.interp, "Swank item  \"" + this.tag + "\" doesn't exist");
        }
        if (this.parString != null) {
            CanvasParameter par = this.swkShape.getPar(this.parString);
            return this.getParValue(par, configStyle);
        }
        CanvasParameter[] pars = this.swkShape.getParameters();
        if (pars == null) {
            throw new TclException(this.interp, "Canvas Parameter doesn't exist for Swank Item \"" + this.tag + "\"");
        }
        TclObject result = TclList.newInstance();
        for (int i = 0; i < pars.length; ++i) {
            TclObject value = this.getParValue(pars[i], configStyle);
            TclList.append((Interp)this.interp, (TclObject)result, (TclObject)value);
        }
        return result;
    }

    public void run() {
        Vector shapeList = null;
        try {
            shapeList = this.swkCanvas.getShapesWithTags(this.tag);
        }
        catch (SwkException swkException) {
            // empty catch block
        }
        if (shapeList != null && shapeList.size() > 0) {
            this.swkShape = (SwkShape)shapeList.elementAt(0);
        }
    }

    TclObject getParValue(CanvasParameter par, boolean configStyle) throws TclException {
        if (par != null) {
            TclObject value = par.getValue(this.interp, this.swkShape);
            if (!configStyle) {
                return value;
            }
            TclObject list = TclList.newInstance();
            TclList.append((Interp)this.interp, (TclObject)list, (TclObject)TclString.newInstance((String)("-" + par.getName())));
            TclList.append((Interp)this.interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)this.interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)this.interp, (TclObject)list, (TclObject)TclString.newInstance((String)par.getDefault()));
            TclList.append((Interp)this.interp, (TclObject)list, (TclObject)value);
            return list;
        }
        return TclString.newInstance((String)"");
    }
}

