/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractNativeRunner
extends AbstractCodeRunner
implements Executable {
    protected Value result;
    protected Throwable exception;
    private final Map<Class<?>, Object> constants;
    private final Map<String, Value> globals;
    private int globalsInited;
    private Throwable backtraceInfo;
    public final Value exnOutOfMemory;
    public final Value exnSysError;
    public final Value exnFailure;
    public final Value exnInvalidArgument;
    public final Value exnEndOfFile;
    public final Value exnDivisionByZero;
    public final Value exnNotFound;
    public final Value exnMatchFailure;
    public final Value exnStackOverflow;
    public final Value exnSysBlockedIO;
    public final Value exnAssertFailure;
    public final Value exnUndefinedRecursiveModule;

    public AbstractNativeRunner(NativeParameters nativeParameters) {
        super(nativeParameters.hasRuntimeLock() ? new ContextWithRuntimeLock(nativeParameters, true, new File(".")) : new ContextWithoutRuntimeLock(nativeParameters, true, new File(".")));
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.constants = new HashMap();
        this.globals = new HashMap<String, Value>();
        this.globalsInited = 0;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
        this.exnOutOfMemory = AbstractNativeRunner.buildPredefinedException("Out_of_memory");
        this.exnSysError = AbstractNativeRunner.buildPredefinedException("Sys_error");
        this.exnFailure = AbstractNativeRunner.buildPredefinedException("Failure");
        this.exnInvalidArgument = AbstractNativeRunner.buildPredefinedException("Invalid_argument");
        this.exnEndOfFile = AbstractNativeRunner.buildPredefinedException("End_of_file");
        this.exnDivisionByZero = AbstractNativeRunner.buildPredefinedException("Division_by_zero");
        this.exnNotFound = AbstractNativeRunner.buildPredefinedException("Not_found");
        this.exnMatchFailure = AbstractNativeRunner.buildPredefinedException("Match_failure");
        this.exnStackOverflow = AbstractNativeRunner.buildPredefinedException("Stack_overflow");
        this.exnSysBlockedIO = AbstractNativeRunner.buildPredefinedException("Sys_blocked_io");
        this.exnAssertFailure = AbstractNativeRunner.buildPredefinedException("Assert_failure");
        this.exnUndefinedRecursiveModule = AbstractNativeRunner.buildPredefinedException("Undefined_recursive_module");
    }

    public AbstractNativeRunner(AbstractNativeRunner abstractNativeRunner) {
        super(abstractNativeRunner.context);
        this.constants = abstractNativeRunner.constants;
        this.globals = abstractNativeRunner.globals;
        this.globalsInited = abstractNativeRunner.globalsInited;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
        this.exnOutOfMemory = abstractNativeRunner.exnOutOfMemory;
        this.exnSysError = abstractNativeRunner.exnSysError;
        this.exnFailure = abstractNativeRunner.exnFailure;
        this.exnInvalidArgument = abstractNativeRunner.exnInvalidArgument;
        this.exnEndOfFile = abstractNativeRunner.exnEndOfFile;
        this.exnDivisionByZero = abstractNativeRunner.exnDivisionByZero;
        this.exnNotFound = abstractNativeRunner.exnNotFound;
        this.exnMatchFailure = abstractNativeRunner.exnMatchFailure;
        this.exnStackOverflow = abstractNativeRunner.exnStackOverflow;
        this.exnSysBlockedIO = abstractNativeRunner.exnSysBlockedIO;
        this.exnAssertFailure = abstractNativeRunner.exnAssertFailure;
        this.exnUndefinedRecursiveModule = abstractNativeRunner.exnUndefinedRecursiveModule;
    }

    public final Value getResult() {
        return this.result;
    }

    public static AbstractNativeRunner getRunner() {
        return (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
    }

    public static void checkSignals() throws Fail.Exception, Fatal.Exception, FalseExit, OCamlJavaException {
        Signals.processSignal(OCamlJavaThread.getCodeRunner());
    }

    public static Value getAtom(int n) {
        return CurrentContext.CODE_STATE.getAtom(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value loadConstants(Class<?> clazz) throws OCamlJavaException {
        Context context = CurrentContext.CONTEXT;
        try {
            InputStream inputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".consts");
            if (inputStream == null) {
                throw new OCamlJavaException("unable to load constants for " + clazz);
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Value value = MarshalIntern.inputVal(context, dataInputStream, true);
            dataInputStream.close();
            inputStream.close();
            return value;
        }
        catch (IOException | Fail.Exception | Fatal.Exception exception) {
            throw new OCamlJavaException("unable to load constants for " + clazz, exception);
        }
    }

    public final void setConstant(Class<?> clazz, Object object) {
        this.constants.put(clazz, object);
    }

    public static Object getConstants(Class<?> clazz) {
        assert (clazz != null) : "null id";
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        return ((AbstractNativeRunner)codeRunner).constants.get(clazz);
    }

    private static Value buildPredefinedException(String string) {
        assert (string != null) : "null name";
        String string2 = "caml_exn_" + string;
        Value value = Value.createBlock(0, Value.createString(string));
        return value;
    }

    public static Value getGlobal(String string) {
        assert (string != null) : "null id";
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.getGlobal(%s) -> %s\n", string, ((AbstractNativeRunner)codeRunner).globals.get(string));
        }
        return ((AbstractNativeRunner)codeRunner).globals.get(string);
    }

    public final Value getGlobalFromInstance(String string) {
        assert (string != null) : "null id";
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.getGlobalFromInstance(%s) -> %s\n", string, this.globals.get(string));
        }
        return this.globals.get(string);
    }

    public static void setGlobal(String string, Value value) {
        assert (string != null) : "null id";
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.setGlobal(%s, %s)\n", string, value);
        }
        ((AbstractNativeRunner)codeRunner).globals.put(string, value);
    }

    public final int getGlobalsInited() {
        return this.globalsInited;
    }

    public final void incrGlobalsInited() {
        ++this.globalsInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value callback(Value value, Value ... valueArray) throws Fail.Exception, Fatal.Exception, FalseExit {
        boolean bl;
        assert (value != null) : "null closure";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Thread thread = Thread.currentThread();
        boolean bl2 = thread instanceof OCamlJavaThread;
        boolean bl3 = OCamlJavaThread.isRegistered(thread);
        boolean bl4 = bl = !bl2 && !bl3;
        if (bl) {
            this.context.getThreadsState().addAdditionalThread(thread);
        }
        AbstractNativeRunner abstractNativeRunner = this.copy();
        abstractNativeRunner.threadStatus = null;
        abstractNativeRunner.setup(value, valueArray);
        abstractNativeRunner.exception = null;
        try {
            abstractNativeRunner.run();
        }
        finally {
            if (!bl) {
                this.context.getThreadsState().removeAdditionalThread(thread);
            }
        }
        if (abstractNativeRunner.exception != null) {
            if (abstractNativeRunner.exception instanceof Fail.Exception) {
                throw (Fail.Exception)abstractNativeRunner.exception;
            }
            if (abstractNativeRunner.exception instanceof Fatal.Exception) {
                throw (Fatal.Exception)abstractNativeRunner.exception;
            }
            if (abstractNativeRunner.exception instanceof FalseExit) {
                AtExit.execute(null);
                throw (FalseExit)abstractNativeRunner.exception;
            }
            Fatal.raise("error in callback: " + abstractNativeRunner.exception);
        }
        return abstractNativeRunner.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.result = null;
        this.exception = null;
        try {
            if (this.closure == null) {
                try {
                    this.moduleMain();
                }
                catch (Throwable throwable) {
                    this.setBacktraceInfo(throwable);
                    this.exception = throwable;
                }
            } else {
                try {
                    this.result = NativeApply.apply(this.closure, this.args);
                }
                catch (Throwable throwable) {
                    this.setBacktraceInfo(throwable);
                    this.exception = throwable;
                }
            }
        }
        finally {
            if (this.threadStatus != null) {
                ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
            }
        }
    }

    public final void execute() {
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.context.getThreadsState().setMainCodeRunner(this);
        this.setup(null, new Value[0]);
        OCamlJavaThread oCamlJavaThread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), this);
        this.context.getThreadsState().setMainThread(oCamlJavaThread);
        oCamlJavaThread.start();
        while (oCamlJavaThread.isAlive()) {
            try {
                oCamlJavaThread.join();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        if (this.exception != null && !(this.exception instanceof FalseExit)) {
            StandardError.reportNativeException(this, this.exception);
            if (Debug.ENABLED) {
                System.out.println("*** Debugging information:");
                this.exception.printStackTrace(System.out);
            }
            AtExit.execute(null);
        } else {
            AtExit.execute(null);
        }
    }

    @Override
    public final void executeSilently() {
        this.execute();
    }

    public final void executeWithBindings(Map<String, Value> map) {
        this.bindings = map;
        this.execute();
    }

    private StackTraceElement[] filterBackTrace(StackTraceElement[] stackTraceElementArray) {
        assert (stackTraceElementArray != null) : "null elems";
        boolean bl = ((NativeParameters)this.context.getParameters()).isSimplifiedBacktrace();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(Arrays.asList(stackTraceElementArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            StackTraceElement stackTraceElement = (StackTraceElement)iterator.next();
            String string = stackTraceElement.getClassName();
            boolean bl3 = bl2 = string.startsWith("java.lang.") || string.startsWith("java.lang.reflect.") || string.startsWith("java.lang.invoke.") || string.startsWith("org.ocamljava.runtime.kernel.") || string.startsWith("org.ocamljava.runtime.values.");
            if ((!bl || !bl2) && stackTraceElement.getFileName() != null && stackTraceElement.getLineNumber() >= 0) continue;
            iterator.remove();
        }
        return arrayList.toArray(new StackTraceElement[arrayList.size()]);
    }

    @Override
    public final void printExceptionBacktrace(PrintStream printStream) {
        assert (printStream != null) : "null out";
        for (StackTraceElement stackTraceElement : this.filterBackTrace(this.exception.getStackTrace())) {
            printStream.println("\tat " + stackTraceElement);
        }
    }

    public final void setBacktraceInfo(Throwable throwable) {
        if (this.context.getCodeState().isBacktraceActive()) {
            this.backtraceInfo = throwable;
        }
    }

    @Override
    public final void clearBacktraceInfo() {
        this.backtraceInfo = null;
    }

    public final void clearException() {
        this.exception = null;
    }

    @Override
    public final Value getExceptionBacktrace() {
        if (this.backtraceInfo != null) {
            StackTraceElement[] stackTraceElementArray = this.filterBackTrace(this.backtraceInfo.getStackTrace());
            int n = stackTraceElementArray.length;
            Value value = Value.createBlock(0, n);
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                Value value2 = Value.createBlock(0, i == 0 ? Value.TRUE : Value.FALSE, Value.createString(stackTraceElement.getFileName()), Value.createLong(stackTraceElement.getLineNumber()), Value.ZERO, Value.ZERO);
                value.set(i, value2);
            }
            return Value.createBlock(0, value);
        }
        return Value.createBlock(0, Value.createBlock(0));
    }

    @Override
    public final CodeRunner createNewThread(Value value) {
        AbstractNativeRunner abstractNativeRunner = this.copy();
        if (value != null) {
            abstractNativeRunner.setThreadStatus(value);
        }
        return abstractNativeRunner;
    }

    protected abstract AbstractNativeRunner copy();

    protected abstract void moduleMain();

    public static void sharedConstantsBegin() {
    }

    public static void sharedConstantsEnd() {
    }

    public static void initGlobalBegin(int n) {
    }

    public static void initGlobalEnd() {
    }
}

