/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.BigArray;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

final class MemArray {
    private final ByteBuffer data;
    private final int[] dim;
    private final long flags;

    MemArray(long flags, int[] dim, ByteBuffer dat) throws Fail.Exception, Fatal.Exception {
        int numDims = dim.length;
        assert (numDims >= 1 && numDims <= 16) : "invalid number of dimensions";
        assert ((flags & 0xFFL) <= 11L) : "invalid element kind";
        int[] dimCopy = new int[numDims];
        System.arraycopy(dim, 0, dimCopy, 0, numDims);
        if (dat == null) {
            long numElems = 1L;
            for (int i = 0; i < numDims; ++i) {
                if ((numElems *= (long)dimCopy[i]) >= 0L && numElems <= Integer.MAX_VALUE) continue;
                Fail.raiseOutOfMemory();
            }
            long size = numElems * (long)BigArray.CAML_BA_ELEMENT_SIZE[(int)flags & 0xFF];
            if (size < 0L || size > Integer.MAX_VALUE) {
                Fail.raiseOutOfMemory();
            }
            this.data = ByteBuffer.allocate(IntegerUtils.ensure32s(size));
            this.flags = flags & 0x1FFL | 0L;
        } else {
            this.data = dat;
            this.flags = flags & 0x1FFL | 0x400L;
        }
        this.dim = dimCopy;
    }

    ByteBuffer getData() {
        return this.data;
    }

    int getNumDims() {
        return this.dim.length;
    }

    int[] getDims() {
        return this.dim;
    }

    int getDim(int d) throws ArrayIndexOutOfBoundsException {
        return this.dim[d];
    }

    long getFlags() {
        return this.flags;
    }

    Value get(int[] index) throws Fail.Exception {
        assert (index != null) : "null index";
        if (index.length != this.dim.length) {
            Fail.invalidArgument("Bigarray.get: wrong number of indices");
        }
        int offset = this.offset(index);
        switch ((int)this.flags & 0xFF) {
            case 0: {
                return Value.createDouble(this.data.getFloat(offset * 4));
            }
            case 1: {
                return Value.createDouble(this.data.getDouble(offset * 8));
            }
            case 2: {
                return Value.createLong(this.data.get(offset * 1));
            }
            case 3: {
                return Value.createLong(IntegerUtils.signedToUnsignedByte(this.data.get(offset * 1)));
            }
            case 4: {
                return Value.createLong(this.data.getShort(offset * 2));
            }
            case 5: {
                return Value.createLong(IntegerUtils.signedToUnsignedShort(this.data.getShort(offset * 2)));
            }
            case 6: {
                return Value.createInt32(this.data.getInt(offset * 4));
            }
            case 7: {
                return Value.createInt64(this.data.getLong(offset * 8));
            }
            case 9: {
                return Value.createNativeInt(this.data.getLong(offset * 8));
            }
            case 8: {
                return Value.createLong(this.data.getLong(offset * 8));
            }
            case 10: {
                return Value.createDoubleArray(this.data.getFloat(offset * 8), this.data.getFloat(offset * 8) + 4.0f);
            }
            case 11: {
                return Value.createDoubleArray(this.data.getDouble(offset * 16), this.data.getDouble(offset * 16) + 8.0);
            }
        }
        assert (false) : "invalid elements kind";
        return Value.UNIT;
    }

    void set(int[] index, Value newval) throws Fail.Exception {
        assert (index != null) : "null index";
        if (index.length != this.dim.length) {
            Fail.invalidArgument("Bigarray.set: wrong number of indices");
        }
        int offset = this.offset(index);
        switch ((int)this.flags & 0xFF) {
            case 0: {
                this.data.putFloat(offset * 4, (float)newval.asDouble());
                break;
            }
            case 1: {
                this.data.putDouble(offset * 8, newval.asDouble());
                break;
            }
            case 2: 
            case 3: {
                this.data.put(offset * 1, (byte)newval.asLong());
                break;
            }
            case 4: 
            case 5: {
                this.data.putShort(offset * 2, (short)newval.asLong());
                break;
            }
            case 6: {
                this.data.putInt(offset * 4, newval.asInt32());
                break;
            }
            case 7: {
                this.data.putLong(offset * 8, newval.asInt64());
                break;
            }
            case 9: {
                this.data.putLong(offset * 8, newval.asNativeInt());
                break;
            }
            case 8: {
                this.data.putLong(offset * 8, newval.asLong());
                break;
            }
            case 10: {
                this.data.putFloat(offset * 8, (float)newval.getDouble0());
                this.data.putFloat(offset * 8 + 4, (float)newval.getDouble1());
                break;
            }
            case 11: {
                this.data.putDouble(offset * 16, newval.getDouble0());
                this.data.putDouble(offset * 16 + 8, newval.getDouble1());
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
    }

    long getNumElems() {
        long res = 1L;
        int len = this.dim.length;
        for (int i = 0; i < len; ++i) {
            res *= (long)this.dim[i];
        }
        return res;
    }

    int offset(int[] index) throws Fail.Exception {
        assert (index != null) : "null index";
        int offset = 0;
        if ((this.flags & 0x100L) == 0L) {
            for (int i = 0; i < index.length; ++i) {
                if (index[i] >= this.dim[i]) {
                    Fail.arrayBoundError();
                }
                offset = offset * this.dim[i] + index[i];
            }
        } else {
            for (int i = index.length - 1; i >= 0; --i) {
                if (index[i] - 1 >= this.dim[i]) {
                    Fail.arrayBoundError();
                }
                offset = offset * this.dim[i] + (index[i] - 1);
            }
        }
        return offset;
    }

    void unMap() {
        ((MappedByteBuffer)this.data).force();
    }
}

