/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;

public final class PermissionsUtils {
    private static final PosixFilePermission[] POSIX = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};
    private static final Set<PosixFilePermission> EMPTY_SET = new HashSet<PosixFilePermission>();

    private PermissionsUtils() {
    }

    public static int getPermissions(File file) throws IOException {
        Set<PosixFilePermission> set;
        assert (file != null) : "null f";
        try {
            set = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            set = EMPTY_SET;
        }
        int n = 0;
        int n2 = POSIX.length;
        for (int i = 0; i < n2; ++i) {
            if (!set.contains((Object)POSIX[i])) continue;
            n |= 1 << i;
        }
        return n;
    }

    public static void setPermissions(File file, int n) throws IOException {
        assert (file != null) : "null f";
        try {
            Files.setPosixFilePermissions(file.toPath(), PermissionsUtils.intToset(n));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static FileAttribute<?> intToAttributes(int n) {
        try {
            return PosixFilePermissions.asFileAttribute(PermissionsUtils.intToset(n));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    public static Set<PosixFilePermission> intToset(int n) {
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        int n2 = POSIX.length;
        for (int i = 0; i < n2; ++i) {
            if ((n & 1 << i) == 0) continue;
            hashSet.add(POSIX[i]);
        }
        return hashSet;
    }
}

