/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.InputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.OutputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.ParameterComponents;
import org.ocamljava.runtime.annotations.parameters.SimpleParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.util.ShellUtils;

public final class Parameters {
    private static final String SHORT_ARG_PREFIX = "-";
    private static final String LONG_ARG_PREFIX = "--";
    private static final String ARG_SEPARATOR = "=";
    private static final String DIALOG_TITLE = "Interpreter parameters";
    private static final int DIALOG_BORDER = 16;

    private Parameters() {
    }

    public static ByteCodeParameters defaultByteCodeParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
        return (ByteCodeParameters)object;
    }

    public static NativeParameters defaultNativeParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = Parameters.newProxyInstance(NativeParameters.class, hashMap, null);
        return (NativeParameters)object;
    }

    public static ByteCodeParameters fromArray(String[] stringArray, File file) throws ParameterException {
        String[] stringArray2;
        assert (stringArray != null) : "null args";
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n && stringArray[n2].startsWith(SHORT_ARG_PREFIX)) {
            boolean bl;
            String string;
            if (stringArray[n2].startsWith(LONG_ARG_PREFIX)) {
                String[] stringArray3;
                if ((stringArray3 = stringArray[n2++].split(ARG_SEPARATOR)).length > 2) {
                    throw new ParameterException("invalid switch format");
                }
                string = stringArray3[0].substring(LONG_ARG_PREFIX.length());
                stringArray2 = stringArray3.length > 1 ? stringArray3[1] : null;
                bl = false;
            } else {
                string = stringArray[n2++].substring(SHORT_ARG_PREFIX.length());
                stringArray2 = n2 < n ? stringArray[n2] : null;
                bl = true;
            }
            if ("".equals(string)) {
                throw new ParameterException("invalid switch name");
            }
            boolean bl2 = false;
            for (Method method : methodArray) {
                if (!string.equals(Parameters.getCommandLineSwitch(method))) continue;
                bl2 = true;
                hashMap.put(Parameters.getKey(method), Parameters.convertValue((String)stringArray2, method));
                if (!bl || method.getAnnotation(SimpleParameter.class) != null) break;
                ++n2;
                break;
            }
            if (bl2) continue;
            throw new ParameterException(String.format("unknown switch '%s'", string));
        }
        hashMap.put("FILE", n2 < n ? stringArray[n2] : null);
        int n3 = n - n2;
        stringArray2 = new String[n3];
        System.arraycopy(stringArray, n2, stringArray2, 0, n3);
        if (file != null) {
            try {
                stringArray2 = ShellUtils.expandCommandLine(file, stringArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        hashMap.put("ARGUMENTS", stringArray2);
        Object object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
        return (ByteCodeParameters)object;
    }

    public static ByteCodeParameters fromProperties(Properties properties) throws ParameterException {
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            for (Method method : methodArray) {
                if (!entry.getKey().equals(Parameters.getCommandLineSwitch(method))) continue;
                hashMap.put(Parameters.getKey(method), Parameters.convertValue((String)entry.getValue(), method));
            }
        }
        Object object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
        return (ByteCodeParameters)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NativeParameters fromStream(InputStream inputStream, String[] stringArray, InputStream inputStream2, PrintStream printStream, PrintStream printStream2, boolean bl, String string, Class<?> clazz) throws OCamlJavaException {
        assert (inputStream != null) : "null is";
        assert (stringArray != null) : "null args";
        assert (inputStream2 != null) : "null in";
        assert (printStream != null) : "null out";
        assert (printStream2 != null) : "null err";
        assert (string != null) : "null file";
        assert (clazz != null) : "null base";
        try {
            Object object;
            String[] stringArray22;
            Properties properties = new Properties();
            properties.load(inputStream);
            Method[] methodArray = NativeParameters.class.getMethods();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String[] stringArray22 : properties.entrySet()) {
                for (Method method : methodArray) {
                    String string2 = Parameters.getCommandLineSwitch(method);
                    if (!stringArray22.getKey().equals(string2)) continue;
                    hashMap.put(Parameters.getKey(method), Parameters.convertValue((String)stringArray22.getValue(), method));
                }
            }
            int n = stringArray.length;
            stringArray22 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray22, 1, n);
            try {
                object = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toString();
            }
            catch (Throwable throwable) {
                object = string;
            }
            stringArray22[0] = object;
            hashMap.put("ARGUMENTS", stringArray22);
            hashMap.put("IN", inputStream2);
            hashMap.put("OUT", printStream);
            hashMap.put("ERR", printStream2);
            hashMap.put("BARE_CANVAS", bl ? Boolean.TRUE : Boolean.FALSE);
            hashMap.put("FILE", string);
            Object object2 = Parameters.newProxyInstance(NativeParameters.class, hashMap, null);
            return (NativeParameters)object2;
        }
        catch (IOException iOException) {
            throw new OCamlJavaException("unable to load parameters", iOException);
        }
    }

    public static ByteCodeParameters fromDialog(ByteCodeParameters byteCodeParameters) throws ParameterException {
        Object object;
        Object object3;
        assert (byteCodeParameters != null) : "null bcp";
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        int n = 0;
        for (Method method : methodArray) {
            object3 = Parameters.getGUILabel(method);
            if (object3 == null || ((String)object3).equals("")) continue;
            ++n;
        }
        final JDialog jDialog = new JDialog((Frame)null, DIALOG_TITLE, true);
        jDialog.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel(new GridLayout(n, 2, 4, 4));
        JComponent[] jComponentArray = new JComponent[n];
        int n2 = 0;
        for (Method object22 : methodArray) {
            object = Parameters.getGUILabel(object22);
            if (object == null || ((String)object).equals("")) continue;
            JComponent n3 = ParameterComponents.createComponent(object22, byteCodeParameters);
            jPanel.add(new JLabel((String)object, 4));
            jPanel.add(n3);
            jComponentArray[n2++] = n3;
        }
        object3 = new JPanel(new BorderLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        ((Container)object3).add(Box.createHorizontalGlue(), "Center");
        ((Container)object3).add((Component)jButton, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)object3, "South");
        Container container = jDialog.getContentPane();
        container.add(Box.createVerticalStrut(16), "North");
        container.add(Box.createVerticalStrut(16), "South");
        container.add(Box.createHorizontalStrut(16), "East");
        container.add(Box.createHorizontalStrut(16), "West");
        container.add((Component)jPanel2, "Center");
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        object = new HashMap();
        int n3 = 0;
        for (Method method : methodArray) {
            String string = Parameters.getGUILabel(method);
            if (string == null || string.equals("")) continue;
            JComponent jComponent = jComponentArray[n3++];
            object.put(Parameters.getKey(method), ParameterComponents.readComponentValue(method, jComponent));
        }
        Object object2 = Parameters.newProxyInstance(ByteCodeParameters.class, (Map<String, Object>)object, byteCodeParameters);
        return (ByteCodeParameters)object2;
    }

    public static ByteCodeParameters setFile(ByteCodeParameters byteCodeParameters, String string) {
        assert (byteCodeParameters != null) : "null bcp";
        return Parameters.setByteCodeParameter(byteCodeParameters, "FILE", string);
    }

    public static NativeParameters setFile(NativeParameters nativeParameters, String string) {
        assert (nativeParameters != null) : "null np";
        return Parameters.setNativeParameter(nativeParameters, "FILE", string);
    }

    public static ByteCodeParameters setUnparsedElements(ByteCodeParameters byteCodeParameters, String[] stringArray) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (stringArray != null) : "null value";
        return Parameters.setByteCodeParameter(byteCodeParameters, "ARGUMENTS", stringArray);
    }

    public static NativeParameters setUnparsedElements(NativeParameters nativeParameters, String[] stringArray) {
        assert (nativeParameters != null) : "null np";
        assert (stringArray != null) : "null value";
        return Parameters.setNativeParameter(nativeParameters, "ARGUMENTS", stringArray);
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters byteCodeParameters, CommonParameters.BooleanParameterID booleanParameterID, boolean bl) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (booleanParameterID != null) : "null id";
        return Parameters.setByteCodeParameter(byteCodeParameters, booleanParameterID.name(), bl);
    }

    public static NativeParameters setBooleanParameter(NativeParameters nativeParameters, CommonParameters.BooleanParameterID booleanParameterID, boolean bl) {
        assert (nativeParameters != null) : "null np";
        assert (booleanParameterID != null) : "null id";
        return Parameters.setNativeParameter(nativeParameters, booleanParameterID.name(), bl);
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters byteCodeParameters, ByteCodeParameters.BooleanParameterID booleanParameterID, boolean bl) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (booleanParameterID != null) : "null id";
        return Parameters.setByteCodeParameter(byteCodeParameters, booleanParameterID.name(), bl);
    }

    public static NativeParameters setBooleanParameter(NativeParameters nativeParameters, NativeParameters.BooleanParameterID booleanParameterID, boolean bl) {
        assert (nativeParameters != null) : "null np";
        assert (booleanParameterID != null) : "null id";
        return Parameters.setNativeParameter(nativeParameters, booleanParameterID.name(), bl);
    }

    public static ByteCodeParameters setIntegerParameter(ByteCodeParameters byteCodeParameters, ByteCodeParameters.IntegerParameterID integerParameterID, int n) throws ParameterException {
        Method[] methodArray;
        assert (byteCodeParameters != null) : "null bcp";
        assert (integerParameterID != null) : "null id";
        for (Method method : methodArray = ByteCodeParameters.class.getMethods()) {
            IntegerParameter integerParameter;
            if (!integerParameterID.name().equals(Parameters.getKey(method)) || n >= (integerParameter = method.getAnnotation(IntegerParameter.class)).minValue() || n <= integerParameter.maxValue()) continue;
            throw new ParameterException("integer value out of range");
        }
        return Parameters.setByteCodeParameter(byteCodeParameters, integerParameterID.name(), n);
    }

    public static ByteCodeParameters setStringParameter(ByteCodeParameters byteCodeParameters, CommonParameters.StringParameterID stringParameterID, String string) throws ParameterException {
        Method[] methodArray;
        assert (byteCodeParameters != null) : "null bcp";
        assert (stringParameterID != null) : "null id";
        assert (string != null) : "null value";
        for (Method method : methodArray = ByteCodeParameters.class.getMethods()) {
            int n;
            if (!stringParameterID.name().equals(Parameters.getKey(method))) continue;
            StringParameter stringParameter = method.getAnnotation(StringParameter.class);
            String[] stringArray = stringParameter.possibleValues();
            int n2 = stringArray.length;
            for (n = 0; n < n2 && !stringArray[n].equals(string); ++n) {
            }
            if (n2 <= 0 || n != n2) continue;
            throw new ParameterException("invalid string value");
        }
        return Parameters.setByteCodeParameter(byteCodeParameters, stringParameterID.name(), string);
    }

    public static NativeParameters setStringParameter(NativeParameters nativeParameters, CommonParameters.StringParameterID stringParameterID, String string) throws ParameterException {
        Method[] methodArray;
        assert (nativeParameters != null) : "null np";
        assert (stringParameterID != null) : "null id";
        assert (string != null) : "null value";
        for (Method method : methodArray = ByteCodeParameters.class.getMethods()) {
            int n;
            if (!stringParameterID.name().equals(Parameters.getKey(method))) continue;
            StringParameter stringParameter = method.getAnnotation(StringParameter.class);
            String[] stringArray = stringParameter.possibleValues();
            int n2 = stringArray.length;
            for (n = 0; n < n2 && !stringArray[n].equals(string); ++n) {
            }
            if (n2 <= 0 || n != n2) continue;
            throw new ParameterException("invalid string value");
        }
        return Parameters.setNativeParameter(nativeParameters, stringParameterID.name(), string);
    }

    public static ByteCodeParameters setInputStreamParameter(ByteCodeParameters byteCodeParameters, CommonParameters.InputStreamParameterID inputStreamParameterID, InputStream inputStream) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (inputStreamParameterID != null) : "null id";
        assert (inputStream != null) : "null value";
        return Parameters.setByteCodeParameter(byteCodeParameters, inputStreamParameterID.name(), inputStream);
    }

    public static NativeParameters setInputStreamParameter(NativeParameters nativeParameters, CommonParameters.InputStreamParameterID inputStreamParameterID, InputStream inputStream) {
        assert (nativeParameters != null) : "null np";
        assert (inputStreamParameterID != null) : "null id";
        assert (inputStream != null) : "null value";
        return Parameters.setNativeParameter(nativeParameters, inputStreamParameterID.name(), inputStream);
    }

    public static ByteCodeParameters setPrintStreamParameter(ByteCodeParameters byteCodeParameters, CommonParameters.PrintStreamParameterID printStreamParameterID, PrintStream printStream) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (printStreamParameterID != null) : "null id";
        assert (printStream != null) : "null value";
        return Parameters.setByteCodeParameter(byteCodeParameters, printStreamParameterID.name(), printStream);
    }

    public static NativeParameters setPrintStreamParameter(NativeParameters nativeParameters, CommonParameters.PrintStreamParameterID printStreamParameterID, PrintStream printStream) {
        assert (nativeParameters != null) : "null np";
        assert (printStreamParameterID != null) : "null id";
        assert (printStream != null) : "null value";
        return Parameters.setNativeParameter(nativeParameters, printStreamParameterID.name(), printStream);
    }

    private static ByteCodeParameters setByteCodeParameter(ByteCodeParameters byteCodeParameters, String string, Object object) {
        assert (byteCodeParameters != null) : "null bcp";
        assert (string != null) : "null name";
        return (ByteCodeParameters)Parameters.setParameter(byteCodeParameters, ByteCodeParameters.class, string, object);
    }

    private static NativeParameters setNativeParameter(NativeParameters nativeParameters, String string, Object object) {
        assert (nativeParameters != null) : "null np";
        assert (string != null) : "null name";
        return (NativeParameters)Parameters.setParameter(nativeParameters, NativeParameters.class, string, object);
    }

    private static Object setParameter(Object object, Class<?> clazz, String string, Object object2) {
        assert (object != null) : "null params";
        assert (clazz != null) : "null cls";
        assert (string != null) : "null name";
        try {
            MapProxy mapProxy = (MapProxy)Proxy.getInvocationHandler(object);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(mapProxy.values);
            hashMap.put(string, object2);
            Object object3 = Parameters.newProxyInstance(clazz, hashMap, mapProxy.fallbackInstance);
            return object3;
        }
        catch (Throwable throwable) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object2);
            Object object4 = Parameters.newProxyInstance(clazz, hashMap, object);
            return object4;
        }
    }

    public static void printUsage(boolean bl, PrintStream printStream) {
        String string;
        String string2;
        String string3;
        assert (printStream != null) : "null out";
        if (bl) {
            printStream.println("\\begin{enumerate}");
        } else {
            printStream.printf("OCaml-Java version %s (c) %s, %s\n", "2.0-early-access8", "Xavier Clerc", "2007-2013");
            printStream.printf("homepage: %s -- contact: %s\n", "http://www.ocamljava.org", "xclerc@ocamljava.org");
            printStream.println("usage: <interpreter arguments> <filename> <application arguments>");
            printStream.println("possible interpreter arguments:");
        }
        if (bl) {
            string3 = "  \\item[] \\texttt{";
            string2 = "} or \\texttt{";
            string = "} \\\\";
        } else {
            string3 = "  ";
            string2 = "\n  ";
            string = "";
        }
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        Arrays.sort(methodArray, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                String string = Parameters.getCommandLineSwitch(method);
                String string2 = string != null ? string : "";
                String string3 = Parameters.getCommandLineSwitch(method2);
                String string4 = string3 != null ? string3 : "";
                return string2.compareTo(string4);
            }
        });
        for (Method method : methodArray) {
            StringParameter stringParameter;
            IntegerParameter integerParameter;
            BooleanParameter booleanParameter;
            SimpleParameter simpleParameter = method.getAnnotation(SimpleParameter.class);
            if (simpleParameter != null && !simpleParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s%s--%s%s\n", string3, simpleParameter.commandLineSwitch(), string2, simpleParameter.commandLineSwitch(), string);
                printStream.printf("        %s\n", simpleParameter.description());
            }
            if ((booleanParameter = method.getAnnotation(BooleanParameter.class)) != null && !booleanParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s <on|off>%s--%s=<on|off>  default:%s%s\n", string3, booleanParameter.commandLineSwitch(), string2, booleanParameter.commandLineSwitch(), booleanParameter.defaultValue() ? "on" : "off", string);
                printStream.printf("        %s\n", booleanParameter.description());
            }
            if ((integerParameter = method.getAnnotation(IntegerParameter.class)) != null && !integerParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s <integer>%s--%s=<integer>  default:%d%s\n", string3, integerParameter.commandLineSwitch(), string2, integerParameter.commandLineSwitch(), integerParameter.defaultValue(), string);
                printStream.printf("        %s\n", integerParameter.description());
            }
            if ((stringParameter = method.getAnnotation(StringParameter.class)) == null || stringParameter.commandLineSwitch().equals("")) continue;
            String string4 = stringParameter.defaultValue();
            printStream.printf("%s-%s <%s>%s--%s=<%s>%s%s\n", string3, stringParameter.commandLineSwitch(), stringParameter.argumentDescription(), string2, stringParameter.commandLineSwitch(), stringParameter.argumentDescription(), string4.equals("") ? "" : "  default:" + string4, string);
            printStream.printf("        %s\n", stringParameter.description());
        }
        if (bl) {
            printStream.println("\\end{enumerate}");
        }
    }

    private static Object getDefaultValue(Method method) {
        SimpleParameter simpleParameter = method.getAnnotation(SimpleParameter.class);
        if (simpleParameter != null) {
            return Boolean.FALSE;
        }
        InputStreamParameter inputStreamParameter = method.getAnnotation(InputStreamParameter.class);
        if (inputStreamParameter != null) {
            return System.in;
        }
        OutputStreamParameter outputStreamParameter = method.getAnnotation(OutputStreamParameter.class);
        if (outputStreamParameter != null) {
            return outputStreamParameter.isErrorOutput() ? System.err : System.out;
        }
        Object object = Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "defaultValue");
        return object;
    }

    private static String getKey(Method method) {
        assert (method != null) : "null m";
        return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "key");
    }

    private static String getGUILabel(Method method) {
        assert (method != null) : "null m";
        return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "guiLabel");
    }

    private static String getCommandLineSwitch(Method method) {
        assert (method != null) : "null m";
        return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "commandLineSwitch");
    }

    private static Object getAnnotationValue(Annotation[] annotationArray, String string) {
        assert (annotationArray != null) : "null annots";
        assert (string != null) : "null methodName";
        Object object = null;
        for (Annotation annotation : annotationArray) {
            try {
                object = annotation.getClass().getMethod(string, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return object;
    }

    private static Object convertValue(String string, Method method) throws ParameterException {
        assert (method != null) : "null meth";
        if (method.getAnnotation(BooleanParameter.class) != null) {
            return Parameters.convertBoolean(string);
        }
        if (method.getAnnotation(IntegerParameter.class) != null) {
            IntegerParameter integerParameter = method.getAnnotation(IntegerParameter.class);
            int n = Parameters.convertInteger(string);
            if (n < integerParameter.minValue() && n > integerParameter.maxValue()) {
                throw new ParameterException("integer value out of range");
            }
            return n;
        }
        if (method.getAnnotation(SimpleParameter.class) != null) {
            return Boolean.TRUE;
        }
        if (method.getAnnotation(StringParameter.class) != null) {
            int n;
            String[] stringArray = method.getAnnotation(StringParameter.class).possibleValues();
            int n2 = stringArray.length;
            for (n = 0; n < n2 && !stringArray[n].equals(string); ++n) {
            }
            if (n2 == 0 || n < n2) {
                return string;
            }
            throw new ParameterException("invalid string value");
        }
        throw new ParameterException("unsuppoted parameter");
    }

    private static Boolean convertBoolean(String string) throws ParameterException {
        if ("on".equals(string)) {
            return Boolean.TRUE;
        }
        if ("off".equals(string)) {
            return Boolean.FALSE;
        }
        throw new ParameterException("switch value should be either 'on' or 'off'");
    }

    private static Integer convertInteger(String string) throws ParameterException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException("switch value should be an integer");
        }
    }

    private static Object newProxyInstance(Class<?> clazz, Map<String, Object> map, Object object) {
        assert (clazz != null) : "null cls";
        assert (map != null) : "null map";
        return Proxy.newProxyInstance(Parameters.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new MapProxy(map, object));
    }

    private static final class MapProxy
    implements InvocationHandler {
        private final Map<String, Object> values;
        private final Object fallbackInstance;

        private MapProxy(Map<String, Object> map, Object object) {
            assert (map != null) : "null v";
            this.values = map;
            this.fallbackInstance = object;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (objectArray == null || objectArray.length == 0) {
                Object object2 = this.values.get(Parameters.getKey(method));
                if (object2 == null) {
                    try {
                        return method.invoke(this.fallbackInstance, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        return Parameters.getDefaultValue(method);
                    }
                }
                return object2;
            }
            throw new IllegalArgumentException("Parameter methods take no parameter");
        }
    }
}

