/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.RejectedExecutionException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.RejectedExecutionHandler;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ScheduledThreadPoolExecutor", source="")
public final class ScheduledThreadPoolExecutor {
    private ScheduledThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "int32", "RejectedExecutionHandler.t"}, returnType="ScheduledThreadPoolExecutor.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_make(Value value, Value value2) throws Fail.Exception {
        try {
            ThreadFactory threadFactory = new ThreadFactory((AbstractNativeRunner)OCamlJavaThread.getCodeRunner());
            java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new java.util.concurrent.ScheduledThreadPoolExecutor(value.asInt32(), threadFactory, RejectedExecutionHandler.decode(value2));
            return Value.createInstance(scheduledThreadPoolExecutor);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_continue_existing_periodic_tasks_after_shutdown_policy(Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        return scheduledThreadPoolExecutor.getContinueExistingPeriodicTasksAfterShutdownPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_execute_existing_delayed_tasks_after_shutdown_policy(Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        return scheduledThreadPoolExecutor.getExecuteExistingDelayedTasksAfterShutdownPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_remove_on_cancel_policy(Value value) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        return scheduledThreadPoolExecutor.getRemoveOnCancelPolicy() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> 'b)", "'a", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        try {
            return Value.createInstance(scheduledThreadPoolExecutor.schedule(new FutureCallable(value2, value3), value4.asInt64(), TimeUnit.decode(value5)));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_at_fixed_rate(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        try {
            return Value.createInstance(scheduledThreadPoolExecutor.scheduleAtFixedRate(new FutureCallable(value2, value3), value4.asInt64(), value5.asInt64(), TimeUnit.decode(value6)));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule_at_fixed_rate");
            return Value.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.schedule_at_fixed_rate");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_with_fixed_delay(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        try {
            return Value.createInstance(scheduledThreadPoolExecutor.scheduleWithFixedDelay(new FutureCallable(value2, value3), value4.asInt64(), value5.asInt64(), TimeUnit.decode(value6)));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.failWith("Concurrent.ScheduledThreadPoolExecutor.schedule_with_fixed_delay");
            return Value.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Fail.invalidArgument("Concurrent.ScheduledThreadPoolExecutor.schedule_with_fixed_delay");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_continue_existing_periodic_tasks_after_shutdown_policy(Value value, Value value2) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(value2 != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_execute_existing_delayed_tasks_after_shutdown_policy(Value value, Value value2) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(value2 != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "bool"}, returnType="unit")
    public static Value ocamljava_scheduledthreadpoolexecutor_get_remove_on_cancel_policy(Value value, Value value2) {
        java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (java.util.concurrent.ScheduledThreadPoolExecutor)value.asCustom();
        scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(value2 != Value.FALSE);
        return Value.UNIT;
    }
}

