/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Marshal", source="byterun/extern.c")
public final class Extern {
    private Extern() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "'a", "Marshal.extern_flags list"}, returnType="unit")
    public static Value caml_output_value(Value value, Value value2, Value value3) throws Fail.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        boolean bl = false;
        try {
            byte[] byArray = MarshalExtern.externValue(codeRunner.getContext(), value2, value3);
            bl = true;
            ((Channel)value.asCustom()).write(byArray);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, bl ? iOException.toString() : "error during marshalling");
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "Marshal.extern_flags list"}, returnType="string")
    public static Value caml_output_value_to_string(Value value, Value value2) throws Fail.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        try {
            byte[] byArray = MarshalExtern.externValue(codeRunner.getContext(), value, value2);
            return Value.createString(byArray);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "error during marshalling");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int", "'a", "Marshal.extern_flags list"}, returnType="int")
    public static Value caml_output_value_to_buffer(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        try {
            byte[] byArray = MarshalExtern.externValue(codeRunner.getContext(), value4, value5);
            int n = value2.asCastedInt();
            int n2 = Math.min(byArray.length, value3.asCastedInt());
            System.arraycopy(byArray, 0, value.getBytesForModification(), n, n2);
            return Value.createLong(n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "error during marshalling");
            return Value.UNIT;
        }
    }
}

