/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;

public final class Primitives2CompatibilityXML
extends AbstractPrimitivesConverter {
    private final PrintStream out;

    private Primitives2CompatibilityXML(String b, String f) throws IOException {
        super(b, null);
        assert (f != null) : "null f";
        this.out = new PrintStream(f);
    }

    private static String normalize(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quote;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static String concat(String[] lines) {
        assert (lines != null) : "null lines";
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String l : lines) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(Primitives2CompatibilityXML.normalize(l));
        }
        return sb.toString();
    }

    @Override
    protected void beforeWalk() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<primitives>");
    }

    @Override
    protected void visitClass(String className) {
        try {
            Class<?> cl = Class.forName(className);
            PrimitiveProvider prov = cl.getAnnotation(PrimitiveProvider.class);
            if (prov != null) {
                for (Method meth : cl.getDeclaredMethods()) {
                    Primitive prim = meth.getAnnotation(Primitive.class);
                    if (prim == null) continue;
                    this.out.printf("  <primitive library=\"%s\" module=\"%s\" name=\"%s\" source=\"%s\" compatibility=\"%s\" comment=\"%s\"/>\n", prov.library(), prim.module().equals("") ? prov.module() : prim.module(), meth.getName(), prov.source(), prim.compatibility().toString().toLowerCase(), Primitives2CompatibilityXML.concat(prim.comment()));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void afterWalk() {
        this.out.println("</primitives>");
        this.out.close();
    }

    public static void main(String[] args) {
        PrintStream err = System.err;
        if (args.length == 2) {
            try {
                Primitives2CompatibilityXML p2c = new Primitives2CompatibilityXML(args[0], args[1]);
                p2c.walkFileTree();
            }
            catch (IOException ioe) {
                err.printf("i/o error: %s\n", ioe.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            err.println("error: a path, and a file should be provided");
            System.exit(1);
        }
    }
}

