/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.GridRowColumnProps;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkGridBagLayout;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JWindow;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.LayoutHandler;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class GridCmd
implements Command {
    private static final int GRID_X = 1;
    private static final int GRID_Y = 2;
    private static final int GRID_HEIGHT = 4;
    private static final int GRID_WIDTH = 8;
    private static final int GRID_PADX = 16;
    private static final int GRID_PADY = 32;
    private static final int GRID_IPADX = 64;
    private static final int GRID_IPADY = 128;
    private static final int GRID_ANCHOR = 256;
    private static final String[] validCmds = new String[]{"bbox", "columnconfigure", "configure", "forget", "info", "location", "propagate", "remove", "rowconfigure", "size", "slaves"};
    private static final int OPT_BBOX = 0;
    private static final int OPT_COLUMNCONFIGURE = 1;
    private static final int OPT_CONFIGURE = 2;
    private static final int OPT_FORGET = 3;
    private static final int OPT_INFO = 4;
    private static final int OPT_LOCATION = 5;
    private static final int OPT_PROPAGATE = 6;
    private static final int OPT_REMOVE = 7;
    private static final int OPT_ROWCONFIGURE = 8;
    private static final int OPT_SIZE = 9;
    private static final int OPT_SLAVES = 10;
    Interp interp = null;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Object masterName = null;
        Object master = null;
        Object gconstr = null;
        Object gbag = null;
        Object widgetObj = null;
        Object tObj = null;
        Object component1 = null;
        this.interp = interp;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
        }
        if (argv[1].toString().charAt(0) == '.') {
            this.configure(interp, argv, 1);
            return;
        }
        String thisArg = argv[1].toString();
        if (thisArg.equals("x") || thisArg.equals("-") || thisArg.equals("^")) {
            this.configure(interp, argv, 1);
            return;
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                this.getBoundingBox(interp, argv);
                break;
            }
            case 2: {
                this.configure(interp, argv, 2);
                break;
            }
            case 1: {
                this.configureRowColumn(interp, argv, true);
                break;
            }
            case 3: {
                this.gridForget(interp, argv, 2);
                break;
            }
            case 5: {
                this.getLocation(interp, argv);
                break;
            }
            case 10: {
                this.getSlaves(interp, argv);
                break;
            }
            case 8: {
                this.configureRowColumn(interp, argv, false);
                break;
            }
            case 4: {
                this.getInfo(interp, argv);
                break;
            }
            case 9: {
                this.getSizes(interp, argv);
                return;
            }
            case 6: {
                this.propagate(interp, argv);
                break;
            }
        }
    }

    SwkGridBagLayout getLayout(Container master) {
        LayoutManager layout = master.getLayout();
        if (layout != null && layout instanceof SwkGridBagLayout) {
            return (SwkGridBagLayout)layout;
        }
        return null;
    }

    Container getMaster(String windowName, boolean useParent) {
        Object masterName = null;
        Container master = null;
        Object layout = null;
        Object gconstr = null;
        Object gbag = null;
        Object widgetObj = null;
        Component component1 = null;
        TclObject tObj = (TclObject)Widgets.getWidget(this.interp, windowName);
        if (tObj == null) {
            return null;
        }
        try {
            widgetObj = ReflectObject.get((Interp)this.interp, (TclObject)tObj);
        }
        catch (TclException tclE) {
            return null;
        }
        component1 = (Component)widgetObj;
        Component component = null;
        component = useParent ? component1.getParent() : component1;
        if (component == null) {
            component = component1;
        }
        if (component instanceof JFrame) {
            master = ((JFrame)component).getContentPane();
            if (master == null) {
                System.out.println("mnull");
            }
        } else if (component instanceof JWindow) {
            master = ((JWindow)component).getContentPane();
            if (master == null) {
                System.out.println("mnull");
            }
        } else {
            master = component instanceof JInternalFrame ? ((JInternalFrame)component).getContentPane() : (Container)component;
        }
        return master;
    }

    private void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        int i;
        int lastSlave = 0;
        String masterName = null;
        int nSlaves = 0;
        boolean lastArgSlave = false;
        boolean endOfWindowArgs = false;
        for (int i2 = start; i2 < argv.length; ++i2) {
            String thisArg = argv[i2].toString();
            if (thisArg.startsWith("-") && thisArg.length() > 1) {
                if (thisArg.equals("-in") && argv.length > i2 + 1) {
                    masterName = argv[i2 + 1].toString();
                    break;
                }
                endOfWindowArgs = true;
                lastArgSlave = false;
            }
            if (endOfWindowArgs) continue;
            if (thisArg.length() > 0 && thisArg.charAt(0) == '.') {
                if (masterName == null) {
                    int lastDot = thisArg.lastIndexOf(".");
                    masterName = lastDot == 0 ? "." : thisArg.substring(0, lastDot);
                }
                ++nSlaves;
                lastArgSlave = true;
                lastSlave = i2;
                continue;
            }
            if (thisArg.equals("-")) {
                if (!lastArgSlave) {
                    throw new TclException(interp, "Must specify window before shortcut '-'.");
                }
                lastArgSlave = true;
                lastSlave = i2;
                continue;
            }
            if (!thisArg.equals("x") && !thisArg.equals("^")) {
                if (nSlaves > 0) {
                    throw new TclException(interp, "unexpected parameter, \"" + thisArg + "\", in configure list. Should be window name or option");
                }
                if (argv.length == 3) {
                    throw new TclException(interp, "bad argument \"" + thisArg + "\": must be name of window");
                }
                throw new TclException(interp, "invalid window shortcut, \"" + thisArg + "\" should be '-', 'x', or '^'");
            }
            lastArgSlave = false;
            lastSlave = i2;
        }
        if (nSlaves == 0) {
            throw new TclException(interp, "can't determine master window");
        }
        int nArgs = argv.length - lastSlave - 1;
        if (nArgs % 2 != 0) {
            throw new TclException(interp, "extra option or option with no value");
        }
        GridBagConstraints gconstr = new GridBagConstraints();
        gconstr.gridy = -1;
        gconstr.gridx = 0;
        gconstr.weightx = 0.0;
        gconstr.weighty = 0.0;
        gconstr.fill = 0;
        int modOptions = 0;
        String[] windows = new String[lastSlave - start + 1];
        for (i = start; i <= lastSlave; ++i) {
            windows[i - start] = argv[i].toString().intern();
            if (!windows[i - start].equals(masterName)) continue;
            throw new TclException(interp, "Window can't be managed in itself");
        }
        for (i = lastSlave + 1; i < argv.length; i += 2) {
            modOptions |= this.parseGridOptions(interp, argv, i, gconstr, null);
        }
        TclObject tObj = (TclObject)Widgets.getWidget(interp, masterName);
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + masterName + "\"");
        }
        Object masterObject = ReflectObject.get((Interp)interp, (TclObject)tObj);
        new Configure().exec(masterName, masterObject, gconstr, windows, modOptions);
    }

    String doit(String masterName, Object masterObject, GridBagConstraints gconstr, String[] windowNames, JComponent[] jcomponents, int modOptions) throws IllegalArgumentException {
        Container master = this.getMasterContainer(masterObject);
        SwkGridBagLayout gbag = null;
        LayoutManager layout = master.getLayout();
        if (layout == null) {
            gbag = new SwkGridBagLayout();
            master.setLayout(gbag);
        } else if (layout instanceof SwkGridBagLayout) {
            gbag = (SwkGridBagLayout)layout;
        } else {
            gbag = new SwkGridBagLayout();
            master.setLayout(gbag);
        }
        if (master.getComponentCount() == 0) {
            gbag.lastRow = 0;
        }
        if (gconstr.gridy == -1) {
            gconstr.gridy = gbag.lastRow;
        }
        Object tObj2 = null;
        JComponent slave = null;
        for (int i = 0; i < jcomponents.length; ++i) {
            String thisArg = windowNames[i];
            if (thisArg.equals("^")) {
                this.extendRow(master, gbag, gconstr.gridx, gconstr.gridy);
                ++gconstr.gridx;
                continue;
            }
            if (thisArg.equals("-")) {
                if (slave != null) {
                    GridBagConstraints gconstr2 = gbag.getConstraints(slave);
                    ++gconstr2.gridwidth;
                    gbag.setConstraints(slave, gconstr2);
                }
                ++gconstr.gridx;
                continue;
            }
            if (thisArg.equals("x")) {
                ++gconstr.gridx;
                continue;
            }
            try {
                slave = this.gridSlave(this.interp, master, masterName, gbag, gconstr, modOptions, jcomponents[i], windowNames[i]);
            }
            catch (IllegalArgumentException iaE) {
                return iaE.getMessage();
            }
            ++gconstr.gridx;
        }
        LayoutHandler.addLayoutRequest(this.interp, master);
        gbag.lastRow = gconstr.gridy + 1;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void configureRowColumn(Interp interp, TclObject[] argv, boolean columnMode) throws TclException {
        int nArgs = argv.length - 4;
        if (nArgs % 2 != 0 && nArgs > 2 || nArgs < 0) {
            throw new TclNumArgsException(interp, 2, argv, "master index ?-option value...?");
        }
        String masterName = argv[2].toString();
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + masterName + "\"");
        }
        if (argv.length == 5) {
            int index = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            if (index < 0) {
                throw new TclException(interp, "index must be positive");
            }
            String key = "" + index;
            GridRowColumnProps rcProps = new RowColumnGet().exec(masterName, columnMode, index);
            String thisArg = argv[4].toString();
            if (thisArg.equals("-minsize")) {
                interp.setResult(rcProps.minSize);
                return;
            } else if (thisArg.equals("-pad")) {
                interp.setResult(rcProps.pad);
                return;
            } else if (thisArg.equals("-uniform")) {
                interp.setResult(rcProps.uniform);
                return;
            } else {
                if (!thisArg.equals("-weight")) throw new TclException(interp, "bad option \"" + thisArg + "\": must be -minsize, -pad, -uniform, or -weight");
                interp.setResult(rcProps.weight);
            }
            return;
        } else if (argv.length == 4) {
            int index = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            if (index < 0) {
                throw new TclException(interp, "index must be positive");
            }
            String key = "" + index;
            GridRowColumnProps rcProps = new RowColumnGet().exec(argv[2].toString(), columnMode, index);
            TclObject list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-minsize"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rcProps.minSize));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-pad"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rcProps.pad));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-uniform"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)rcProps.uniform));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-weight"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rcProps.weight));
            interp.setResult(list);
            return;
        } else {
            TclObject[] indexObjects = null;
            indexObjects = TclList.getElements((Interp)interp, (TclObject)argv[3]);
            for (int j = 0; j < indexObjects.length; ++j) {
                int index = TclInteger.get((Interp)interp, (TclObject)indexObjects[j]);
                if (index < 0) {
                    if (!columnMode) throw new TclException(interp, "grid rowconfigure: \"" + indexObjects[j] + "\" is out of range");
                    throw new TclException(interp, "grid columnconfigure: \"" + indexObjects[j] + "\" is out of range");
                }
                int[] argTypes = new int[(argv.length - 4) / 2];
                Vector<Object> argValues = new Vector<Object>();
                int k = 0;
                for (int i = 4; i < argv.length; i += 2) {
                    int value;
                    if (argv[i].toString().equals("-weight")) {
                        value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                        if (value < 0) {
                            throw new TclException(interp, "invalid arg \"-weight\": should be non-negative");
                        }
                        argTypes[k++] = 1;
                        argValues.add(new Integer(value));
                        continue;
                    }
                    if (argv[i].toString().equals("-minsize")) {
                        value = this.getScreenDistance(interp, null, argv[i], argv[i + 1]);
                        argTypes[k++] = 2;
                        argValues.add(new Integer(value));
                        continue;
                    }
                    if (argv[i].toString().equals("-pad")) {
                        value = this.getScreenDistance(interp, null, argv[i], argv[i + 1]);
                        argTypes[k++] = 3;
                        argValues.add(new Integer(value));
                        continue;
                    }
                    if (!argv[i].toString().equals("-uniform")) continue;
                    argTypes[k++] = 4;
                    argValues.add(argv[i + 1].toString().intern());
                }
                new RowColumnConfigure().exec(masterName, columnMode, index, argTypes, argValues);
            }
        }
    }

    int getScreenDistance(Interp interp, Component component, TclObject argName, TclObject arg) throws TclException {
        int value = 0;
        try {
            value = SwankUtil.getTkSize(interp, component, arg);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "bad screen distance \"" + arg + "\"");
        }
        if (value < 0) {
            throw new TclException(interp, "invalid arg \"" + argName.toString() + "\": should be non-negative");
        }
        return value;
    }

    void getBoundingBox(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 5 && argv.length != 7) {
            throw new TclNumArgsException(interp, 2, argv, "master ?column row ?column row??");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        TclObject list = TclList.newInstance();
        if (argv.length == 3) {
            Rectangle rect = new BoundingBox().exec(argv[2].toString(), argv.length, null);
            if (rect == null) {
                return;
            }
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.x));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.y));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.width));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.height));
        } else {
            if (!Widgets.exists(interp, argv[2].toString())) {
                throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
            }
            int[][] rcVals = new int[2][2];
            rcVals[0][0] = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            rcVals[0][1] = TclInteger.get((Interp)interp, (TclObject)argv[4]);
            rcVals[1][0] = rcVals[0][0];
            rcVals[1][1] = rcVals[0][1];
            Rectangle rect = new BoundingBox().exec(argv[2].toString(), argv.length, rcVals);
            if (rect == null) {
                return;
            }
            if (argv.length == 7) {
                int hold;
                rcVals[1][0] = TclInteger.get((Interp)interp, (TclObject)argv[5]);
                rcVals[1][1] = TclInteger.get((Interp)interp, (TclObject)argv[6]);
                if (rcVals[1][0] < rcVals[0][0]) {
                    hold = rcVals[0][0];
                    rcVals[0][0] = rcVals[1][0];
                    rcVals[1][0] = hold;
                }
                if (rcVals[1][1] < rcVals[0][1]) {
                    hold = rcVals[0][1];
                    rcVals[0][1] = rcVals[1][1];
                    rcVals[1][1] = hold;
                }
            }
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.x));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.y));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.width));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)rect.height));
        }
        interp.setResult(list);
    }

    void gridForget(Interp interp, TclObject[] argv, int firstWindow) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        String[] names = new String[argv.length - firstWindow];
        int j = 0;
        for (int i = firstWindow; i < argv.length; ++i) {
            names[j++] = argv[i].toString();
        }
        new Forget().exec(names);
    }

    void getLocation(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "master x y");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        int x = 0;
        int y = 0;
        try {
            x = SwankUtil.getTkSize(interp, null, argv[3]);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "bad screen distance \"" + argv[3].toString() + "\"");
        }
        try {
            y = SwankUtil.getTkSize(interp, null, argv[4]);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "bad screen distance \"" + argv[4].toString() + "\"");
        }
        Point pt = new Location().exec(argv[2].toString(), x, y);
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)pt.x));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)pt.y));
        interp.setResult(list);
    }

    void getSlaves(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "window ?-option value...?");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        int iRow = -1;
        int iColumn = -1;
        if (argv.length == 5) {
            if (argv[3].toString().equals("-row")) {
                iRow = TclInteger.get((Interp)interp, (TclObject)argv[4]);
                if (iRow < 0) {
                    throw new TclException(interp, argv[3] + " is an invalid value: should NOT be < 0");
                }
            } else if (argv[3].toString().equals("-column")) {
                iColumn = TclInteger.get((Interp)interp, (TclObject)argv[4]);
                if (iColumn < 0) {
                    throw new TclException(interp, argv[3] + " is an invalid value: should NOT be < 0");
                }
            } else {
                throw new TclException(interp, "bad option \"" + argv[3].toString() + "\": must be -column or -row");
            }
        }
        String[] names = new Slaves().exec(argv[2].toString(), iColumn, iRow);
        TclObject list = TclList.newInstance();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)names[i]));
            }
        }
        interp.setResult(list);
    }

    void getInfo(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        interp.resetResult();
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[2].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        Object widgetObj = ReflectObject.get((Interp)interp, (TclObject)tObj);
        Component component = (Component)widgetObj;
        Object constrObject = new Info().exec(argv[2].toString(), component);
        if (constrObject == null || !(constrObject instanceof GridBagConstraints)) {
            return;
        }
        GridBagConstraints gconstr = (GridBagConstraints)constrObject;
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-in"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)Widgets.parent(interp, argv[2].toString())));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-column"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)gconstr.gridx));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-row"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)gconstr.gridy));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-columnspan"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)gconstr.gridwidth));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-rowspan"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)gconstr.gridheight));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-ipadx"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)(gconstr.ipadx / 2)));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-ipady"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)(gconstr.ipady / 2)));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-padx"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)((gconstr.insets.left + gconstr.insets.right) / 2)));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-pady"));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)((gconstr.insets.top + gconstr.insets.bottom) / 2)));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-sticky"));
        StringBuffer sbuf = new StringBuffer();
        String anchorStr = null;
        if (gconstr.fill == 1) {
            anchorStr = "nesw";
        } else if (gconstr.fill == 0) {
            if (gconstr.anchor == 12) {
                anchorStr = "ne";
            } else if (gconstr.anchor == 14) {
                anchorStr = "es";
            } else if (gconstr.anchor == 18) {
                anchorStr = "nw";
            } else if (gconstr.anchor == 16) {
                anchorStr = "sw";
            } else if (gconstr.anchor == 17) {
                anchorStr = "w";
            } else if (gconstr.anchor == 11) {
                anchorStr = "n";
            } else if (gconstr.anchor == 13) {
                anchorStr = "e";
            } else if (gconstr.anchor == 15) {
                anchorStr = "s";
            }
        } else if (gconstr.fill == 2) {
            anchorStr = "ew";
            if (gconstr.anchor == 11) {
                anchorStr = "new";
            } else if (gconstr.anchor == 15) {
                anchorStr = "esw";
            }
        } else if (gconstr.fill == 3) {
            anchorStr = "ns";
            if (gconstr.anchor == 13) {
                anchorStr = "nes";
            } else if (gconstr.anchor == 17) {
                anchorStr = "nsw";
            }
        }
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)anchorStr));
        interp.setResult(list);
    }

    void getSizes(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        Dimension dim = new Sizes().exec(argv[2].toString());
        if (dim == null) {
            throw new TclException(interp, "grid sizes exception");
        }
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)dim.width));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)dim.height));
        interp.setResult(list);
    }

    void propagate(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "window ?boolean?");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        boolean propagate = false;
        boolean setPropagate = false;
        if (argv.length == 4) {
            setPropagate = true;
            propagate = TclBoolean.get((Interp)interp, (TclObject)argv[3]);
        }
        boolean result = new Propagate().exec(argv[2].toString(), propagate, setPropagate);
        interp.setResult(result);
    }

    void extendRow(Container master, SwkGridBagLayout gbag, int x, int y) throws IllegalArgumentException {
        Component[] comps = master.getComponents();
        boolean foundComp = false;
        for (int i = 0; i < comps.length; ++i) {
            GridBagConstraints constr = gbag.getConstraints(comps[i]);
            if (constr == null || !(constr instanceof GridBagConstraints)) continue;
            GridBagConstraints gconstr = constr;
            if (gconstr.gridy < y && gconstr.gridy + gconstr.gridheight > y && gconstr.gridx < x && gconstr.gridx + gconstr.gridwidth > x) {
                return;
            }
            if (gconstr.gridy + gconstr.gridheight != y || gconstr.gridx != x) continue;
            foundComp = true;
            gconstr.gridheight = y - gconstr.gridy + 1;
            gbag.setConstraints(comps[i], gconstr);
            break;
        }
        if (!foundComp) {
            throw new IllegalArgumentException("can't find slave to extend with \"^\".");
        }
    }

    int parseGridOptions(Interp interp, TclObject[] argv, int i, GridBagConstraints gconstr, Component component) throws TclException {
        String thisArg = argv[i].toString();
        int optionSet = 0;
        if (thisArg.equals("-gridx")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 0) {
                throw new TclException(interp, "bad grid value \"" + argv[i + 1].toString() + "\": must be a non-negative integer");
            }
            gconstr.gridx = iValue;
            optionSet = 1;
        } else if (thisArg.equals("-gridy")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 0) {
                throw new TclException(interp, "bad grid value \"" + argv[i + 1].toString() + "\": must be a non-negative integer");
            }
            optionSet = 2;
            gconstr.gridy = iValue;
        } else if (thisArg.equals("-row")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 0) {
                throw new TclException(interp, "bad grid value \"" + argv[i + 1].toString() + "\": must be a non-negative integer");
            }
            optionSet = 2;
            gconstr.gridy = iValue;
        } else if (thisArg.equals("-column")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 0) {
                throw new TclException(interp, "bad column value \"" + argv[i + 1].toString() + "\": must be a non-negative integer");
            }
            optionSet = 1;
            gconstr.gridx = iValue;
        } else if (thisArg.equals("-rowspan")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 1) {
                throw new TclException(interp, "bad rowspan value \"" + argv[i + 1].toString() + "\": must be a positive integer");
            }
            optionSet = 4;
            gconstr.gridheight = iValue;
        } else if (thisArg.equals("-columnspan")) {
            int iValue = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
            if (iValue < 1) {
                throw new TclException(interp, "bad columnspan value \"" + argv[i + 1].toString() + "\": must be a positive integer");
            }
            optionSet = 8;
            gconstr.gridwidth = iValue;
        } else if (thisArg.equals("-ipadx")) {
            int iValue = 0;
            try {
                iValue = SwankUtil.getTkSize(interp, component, argv[i + 1]);
            }
            catch (TclException tclE) {
                throw new TclException(interp, "bad ipadx value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            if (iValue < 0) {
                throw new TclException(interp, "bad ipadx value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            optionSet = 64;
            gconstr.ipadx = iValue * 2;
        } else if (thisArg.equals("-ipady")) {
            int iValue = 0;
            try {
                iValue = SwankUtil.getTkSize(interp, component, argv[i + 1]);
            }
            catch (TclException tclE) {
                throw new TclException(interp, "bad ipady value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            if (iValue < 0) {
                throw new TclException(interp, "bad ipady value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            optionSet = 128;
            gconstr.ipady = iValue * 2;
        } else if (thisArg.equals("-padx") || thisArg.equals("-pady")) {
            double dValue = 0.0;
            TclObject[] padArgs = TclList.getElements((Interp)interp, (TclObject)argv[i + 1]);
            if (padArgs.length < 1 || padArgs.length > 2) {
                throw new TclException(interp, "bad pad value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            for (int iArg = 0; iArg < padArgs.length; ++iArg) {
                String[] argErrors = new String[]{"", " 2nd"};
                try {
                    dValue = SwankUtil.getTkSizeD(interp, component, padArgs[iArg]);
                }
                catch (TclException tclE) {
                    throw new TclException(interp, "bad" + argErrors[iArg] + " pad value \"" + padArgs[iArg].toString() + "\": must be positive screen distance");
                }
                if (dValue < 0.0) {
                    throw new TclException(interp, "bad" + argErrors[iArg] + " pad value \"" + padArgs[iArg].toString() + "\": must be positive screen distance");
                }
                if (thisArg.equals("-padx")) {
                    if (iArg == 0) {
                        gconstr.insets.left = (int)dValue;
                        gconstr.insets.right = (int)dValue;
                    } else {
                        gconstr.insets.right = (int)dValue;
                    }
                    optionSet = 16;
                    continue;
                }
                if (iArg == 0) {
                    gconstr.insets.top = (int)dValue;
                    gconstr.insets.bottom = (int)dValue;
                } else {
                    gconstr.insets.bottom = (int)dValue;
                }
                optionSet = 32;
            }
        } else if (thisArg.equals("-sticky")) {
            String stickyStuff = argv[i + 1].toString();
            for (int j = 0; j < stickyStuff.length(); ++j) {
                if ("nsew, ".indexOf(stickyStuff.charAt(j)) != -1) continue;
                throw new TclException(interp, "bad stickyness value \"" + stickyStuff + "\": must be a string containing n, e, s, and/or w");
            }
            if (stickyStuff.indexOf(119) >= 0 && stickyStuff.indexOf(101) >= 0) {
                if (stickyStuff.indexOf(110) >= 0 && stickyStuff.indexOf(115) >= 0) {
                    gconstr.fill = 1;
                } else {
                    gconstr.fill = 2;
                    if (stickyStuff.indexOf(115) >= 0) {
                        gconstr.anchor = 15;
                    } else if (stickyStuff.indexOf(110) >= 0) {
                        gconstr.anchor = 11;
                    }
                }
            } else if (stickyStuff.indexOf(110) >= 0 && stickyStuff.indexOf(115) >= 0) {
                gconstr.fill = 3;
                if (stickyStuff.indexOf(101) >= 0) {
                    gconstr.anchor = 13;
                } else if (stickyStuff.indexOf(119) >= 0) {
                    gconstr.anchor = 17;
                }
            } else {
                gconstr.fill = 0;
                gconstr.anchor = stickyStuff.indexOf(110) >= 0 ? (stickyStuff.indexOf(101) >= 0 ? 12 : (stickyStuff.indexOf(119) >= 0 ? 18 : 11)) : (stickyStuff.indexOf(115) >= 0 ? (stickyStuff.indexOf(101) >= 0 ? 14 : (stickyStuff.indexOf(119) >= 0 ? 16 : 15)) : (stickyStuff.indexOf(101) >= 0 ? 13 : (stickyStuff.indexOf(119) >= 0 ? 17 : 10)));
            }
            optionSet = 256;
        } else if (!thisArg.equals("-in")) {
            throw new TclException(interp, "unexpected parameter, \"" + thisArg + "\", in configure list. Should be window name or option");
        }
        return optionSet;
    }

    JComponent gridSlave(Interp interp, Container master, String masterName, SwkGridBagLayout gbag, GridBagConstraints gconstr, int modOptions, JComponent slave, String windowName) throws IllegalArgumentException {
        GridBagConstraints currentConstraints = gbag.getConstraints(slave);
        GridBagConstraints applyConstraints = null;
        applyConstraints = currentConstraints.gridx != -1 ? this.updateConstraints(gconstr, currentConstraints, modOptions) : gconstr;
        slave.invalidate();
        String column = "" + applyConstraints.gridx;
        GridRowColumnProps columnProps = gbag.getColumnProps(column, applyConstraints.gridx);
        applyConstraints.weightx = columnProps.weight;
        String row = "" + applyConstraints.gridy;
        GridRowColumnProps rowProps = gbag.getRowProps(row, applyConstraints.gridy);
        applyConstraints.weighty = rowProps.weight;
        gbag.setConstraints(slave, applyConstraints);
        if (!master.isAncestorOf(slave)) {
            try {
                master.add(slave);
            }
            catch (IllegalArgumentException iaE) {
                throw new IllegalArgumentException("can't put \"" + windowName + "\" inside \"" + masterName + "\"");
            }
        }
        return slave;
    }

    Container getMasterContainer(Object masterObj) {
        Container master = null;
        master = masterObj instanceof JFrame ? ((JFrame)masterObj).getContentPane() : (masterObj instanceof JWindow ? ((JWindow)masterObj).getContentPane() : (masterObj instanceof JInternalFrame ? ((JInternalFrame)masterObj).getContentPane() : (Container)masterObj));
        return master;
    }

    GridBagConstraints updateConstraints(GridBagConstraints gconstr, GridBagConstraints currentConstraints, int modOptions) {
        if (currentConstraints != null) {
            if ((modOptions & 1) == 1) {
                currentConstraints.gridx = gconstr.gridx;
            }
            if ((modOptions & 2) == 2) {
                currentConstraints.gridy = gconstr.gridy;
            }
            if ((modOptions & 4) == 4) {
                currentConstraints.gridheight = gconstr.gridheight;
            }
            if ((modOptions & 8) == 8) {
                currentConstraints.gridwidth = gconstr.gridwidth;
            }
            if ((modOptions & 0x10) == 16) {
                currentConstraints.insets.left = gconstr.insets.left;
                currentConstraints.insets.right = gconstr.insets.right;
            }
            if ((modOptions & 0x20) == 32) {
                currentConstraints.insets.top = gconstr.insets.top;
                currentConstraints.insets.bottom = gconstr.insets.bottom;
            }
            if ((modOptions & 0x40) == 64) {
                currentConstraints.ipadx = gconstr.ipadx;
            }
            if ((modOptions & 0x80) == 128) {
                currentConstraints.ipady = gconstr.ipady;
            }
            if ((modOptions & 0x100) == 256) {
                currentConstraints.anchor = gconstr.anchor;
                currentConstraints.fill = gconstr.fill;
            }
        }
        return currentConstraints;
    }

    class Propagate
    extends GetValueOnEventThread {
        String item = null;
        boolean propagate = false;
        boolean setPropagate = false;

        Propagate() {
        }

        boolean exec(String item, boolean propagate, boolean setPropagate) {
            this.item = item;
            this.propagate = propagate;
            this.setPropagate = setPropagate;
            this.execOnThread();
            return this.propagate;
        }

        public void run() {
            Container parent = null;
            try {
                parent = Widgets.getContainer(GridCmd.this.interp, this.item);
            }
            catch (TclException tclE) {
                GridCmd.this.interp.backgroundError();
                System.out.println("error " + tclE.getMessage());
            }
            LayoutManager layoutManager = parent.getLayout();
            SwkGridBagLayout gbag = null;
            if (!(layoutManager instanceof SwkGridBagLayout)) {
                parent.removeAll();
                gbag = new SwkGridBagLayout();
                parent.setLayout(gbag);
            } else {
                gbag = (SwkGridBagLayout)layoutManager;
            }
            if (this.setPropagate) {
                gbag.propagate = this.propagate;
                Widgets.relayoutContainer(parent);
            }
            this.propagate = gbag.propagate;
        }
    }

    class Sizes
    extends GetValueOnEventThread {
        String item = null;
        Component component = null;
        Object constrObject = null;
        Dimension dim = null;

        Sizes() {
        }

        Dimension exec(String item) {
            this.item = item;
            this.component = this.component;
            this.execOnThread();
            return this.dim;
        }

        public void run() {
            Container master = GridCmd.this.getMaster(this.item, true);
            SwkGridBagLayout gbag = GridCmd.this.getLayout(master);
            int nX = 0;
            int nY = 0;
            Component[] comps = master.getComponents();
            for (int i = 0; comps != null && i < comps.length; ++i) {
                GridBagConstraints constr = gbag.getConstraints(comps[i]);
                if (constr == null || !(constr instanceof GridBagConstraints)) continue;
                GridBagConstraints gconstr = constr;
                if (gconstr.gridx >= nX) {
                    nX = gconstr.gridx + 1;
                }
                if (gconstr.gridy < nY) continue;
                nY = gconstr.gridy + 1;
            }
            if (gbag != null) {
                int rowMax;
                int colMax = gbag.getRCMax(true);
                if (colMax >= nX) {
                    nX = colMax + 1;
                }
                if ((rowMax = gbag.getRCMax(false)) >= nY) {
                    nY = rowMax + 1;
                }
            }
            this.dim = new Dimension(nX, nY);
        }
    }

    class Info
    extends GetValueOnEventThread {
        String item = null;
        Component component = null;
        Object constrObject = null;

        Info() {
        }

        Object exec(String item, Component component) {
            this.item = item;
            this.component = component;
            this.execOnThread();
            return this.constrObject;
        }

        public void run() {
            Container master = GridCmd.this.getMaster(this.item, true);
            SwkGridBagLayout gbag = GridCmd.this.getLayout(master);
            if (gbag == null) {
                return;
            }
            this.constrObject = gbag.getConstraints(this.component);
        }
    }

    class Slaves
    extends GetValueOnEventThread {
        String item = null;
        String[] names = null;
        int iColumn = -1;
        int iRow = -1;

        Slaves() {
        }

        String[] exec(String item, int iColumn, int iRow) {
            this.item = item;
            this.iColumn = iColumn;
            this.iRow = iRow;
            this.execOnThread();
            return this.names;
        }

        public void run() {
            Container parent = null;
            Container master = null;
            SwkGridBagLayout gbag = null;
            try {
                parent = Widgets.getContainer(GridCmd.this.interp, this.item);
                master = GridCmd.this.getMaster(this.item, true);
                if (master == null) {
                    return;
                }
                gbag = GridCmd.this.getLayout(master);
            }
            catch (TclException tclE) {
                GridCmd.this.interp.backgroundError();
                return;
            }
            if (gbag == null) {
                return;
            }
            int nMembers = parent.getComponentCount();
            this.names = new String[nMembers];
            for (int i = nMembers - 1; i >= 0; --i) {
                Component comp = parent.getComponent(i);
                if (this.iRow >= 0 || this.iColumn >= 0) {
                    if (gbag == null) {
                        System.out.println("null gbag");
                        GridCmd.this.interp.resetResult();
                        return;
                    }
                    GridBagConstraints constr = gbag.getConstraints(comp);
                    if (constr == null || !(constr instanceof GridBagConstraints)) continue;
                    GridBagConstraints gconstr = constr;
                    if (this.iRow >= 0 && gconstr.gridy == this.iRow) {
                        this.names[i] = comp.getName();
                        continue;
                    }
                    if (this.iColumn < 0 || gconstr.gridx != this.iColumn) continue;
                    this.names[i] = comp.getName();
                    continue;
                }
                this.names[i] = comp.getName();
            }
        }
    }

    class Location
    extends GetValueOnEventThread {
        String item = null;
        String[] names = null;
        int x = -1;
        int y = -1;
        Point pt = new Point();

        Location() {
        }

        Point exec(String item, int x, int y) {
            this.item = item;
            this.x = x;
            this.y = y;
            this.execOnThread();
            return this.pt;
        }

        public void run() {
            Container parent = null;
            try {
                parent = Widgets.getContainer(GridCmd.this.interp, this.item);
            }
            catch (TclException tclE) {
                GridCmd.this.interp.backgroundError();
                return;
            }
            LayoutManager layoutManager = parent.getLayout();
            Dimension dim = parent.getSize();
            if (!(layoutManager instanceof SwkGridBagLayout)) {
                this.pt.x = -1;
                this.pt.y = -1;
                return;
            }
            Rectangle rect = parent.getBounds();
            if (this.x >= dim.width) {
                --this.x;
            }
            if (this.y >= dim.height) {
                --this.y;
            }
            Point pt = ((SwkGridBagLayout)layoutManager).location(this.x, this.y);
            if (this.x < pt.x) {
                pt.x = -1;
            }
            if (this.y < pt.y) {
                pt.y = -1;
            }
        }
    }

    class Forget
    extends UpdateOnEventThread {
        String[] names = null;

        Forget() {
        }

        void exec(String[] names) {
            this.names = names;
            this.execOnThread();
        }

        public void run() {
            try {
                for (int i = 0; i < this.names.length; ++i) {
                    Container parent;
                    LayoutManager layoutManager;
                    String parentName;
                    if (!Widgets.exists(GridCmd.this.interp, this.names[i]) || (parentName = Widgets.parent(GridCmd.this.interp, this.names[i])).equals("") || !((layoutManager = (parent = Widgets.getContainer(GridCmd.this.interp, parentName)).getLayout()) instanceof SwkGridBagLayout)) continue;
                    SwkWidget window = (SwkWidget)Widgets.get(GridCmd.this.interp, this.names[i]);
                    parent.remove((Component)((Object)window));
                    Widgets.relayoutContainer(parent);
                    parent.repaint();
                }
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
    }

    class BoundingBox
    extends GetValueOnEventThread {
        String item = null;
        Component component = null;
        Object constrObject = null;
        int nArgs = 0;
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        int[][] rcVals = null;

        BoundingBox() {
        }

        Rectangle exec(String item, int nArgs, int[][] rcVals) {
            this.item = item;
            this.component = this.component;
            this.rcVals = rcVals;
            this.nArgs = 0;
            this.execOnThread();
            return this.rect;
        }

        public void run() {
            Container master = GridCmd.this.getMaster(this.item, true);
            SwkGridBagLayout gbag = GridCmd.this.getLayout(master);
            if (master == null) {
                return;
            }
            if (this.nArgs > 3) {
                Component[] comps = master.getComponents();
                boolean outOfRange = true;
                for (int i = 0; comps != null && i < comps.length; ++i) {
                    GridBagConstraints constr = gbag.getConstraints(comps[i]);
                    if (constr == null || !(constr instanceof GridBagConstraints)) continue;
                    GridBagConstraints gconstr = constr;
                    if (this.nArgs == 5) {
                        if (gconstr.gridx != this.rcVals[0][0] || gconstr.gridy != this.rcVals[0][1]) continue;
                        this.rect = comps[i].getBounds();
                        break;
                    }
                    if (gconstr.gridx < this.rcVals[0][0] || gconstr.gridy < this.rcVals[0][1]) continue;
                    outOfRange = false;
                    if (gconstr.gridx > this.rcVals[1][0] || gconstr.gridy > this.rcVals[1][1]) continue;
                    this.rect = (Rectangle)this.rect.createUnion(comps[i].getBounds());
                }
                if (this.nArgs == 7 && outOfRange) {
                    this.rect.x = master.getBounds().width;
                    this.rect.y = master.getBounds().height;
                    this.rect.width = 0;
                    this.rect.height = 0;
                }
            } else {
                Component[] comps = master.getComponents();
                for (int i = 0; comps != null && i < comps.length; ++i) {
                    if (i == 0) {
                        this.rect.setBounds(comps[i].getBounds());
                        continue;
                    }
                    this.rect = (Rectangle)this.rect.createUnion(comps[i].getBounds());
                }
            }
        }
    }

    class RowColumnConfigure
    extends UpdateOnEventThread {
        static final int WEIGHT = 1;
        static final int MINSIZE = 2;
        static final int PAD = 3;
        static final int UNIFORM = 4;
        String item = null;
        int index = 0;
        boolean columnMode = false;
        int[] argTypes = null;
        Vector argValues = null;

        RowColumnConfigure() {
        }

        void exec(String item, boolean columnMode, int index, int[] argTypes, Vector argValues) {
            this.item = item;
            this.columnMode = columnMode;
            this.index = index;
            this.argTypes = argTypes;
            this.argValues = argValues;
            this.execOnThread();
        }

        public void run() {
            String key;
            GridRowColumnProps rcProps;
            Container master = GridCmd.this.getMaster(this.item, false);
            SwkGridBagLayout gbag = GridCmd.this.getLayout(master);
            if (gbag == null) {
                gbag = new SwkGridBagLayout();
                master.setLayout(gbag);
            }
            if ((rcProps = gbag.getProps(this.columnMode, key = "" + this.index, this.index)) == null) {
                System.out.println("rcProps null");
            }
            GridRowColumnProps newProps = (GridRowColumnProps)rcProps.clone();
            block6: for (int i = 0; i < this.argTypes.length; ++i) {
                switch (this.argTypes[i]) {
                    case 1: {
                        newProps.weight = (Integer)this.argValues.elementAt(i);
                        gbag.setWeight(this.columnMode, this.index, newProps.weight);
                        continue block6;
                    }
                    case 2: {
                        newProps.minSize = (Integer)this.argValues.elementAt(i);
                        gbag.setMinSize(this.columnMode, this.index, newProps.minSize);
                        continue block6;
                    }
                    case 3: {
                        newProps.pad = (Integer)this.argValues.elementAt(i);
                        continue block6;
                    }
                    case 4: {
                        newProps.uniform = (String)this.argValues.elementAt(i);
                        continue block6;
                    }
                    default: {
                        System.out.println("invalid argType " + this.argTypes[i]);
                    }
                }
            }
            if (this.columnMode) {
                gbag.putColumnProps(key, newProps);
            } else {
                gbag.putRowProps(key, newProps);
            }
        }
    }

    class RowColumnGet
    extends GetValueOnEventThread {
        String item = null;
        String[] names = null;
        int index = 0;
        boolean columnMode = false;
        GridRowColumnProps rcProps = null;

        RowColumnGet() {
        }

        GridRowColumnProps exec(String item, boolean columnMode, int index) {
            this.item = item;
            this.columnMode = columnMode;
            this.index = index;
            this.execOnThread();
            return this.rcProps;
        }

        public void run() {
            Container master = GridCmd.this.getMaster(this.item, false);
            SwkGridBagLayout gbag = GridCmd.this.getLayout(master);
            if (gbag == null) {
                gbag = new SwkGridBagLayout();
                master.setLayout(gbag);
            }
            String key = "" + this.index;
            this.rcProps = gbag.getProps(this.columnMode, key, this.index);
        }
    }

    class Configure
    extends GetValueOnEventThread {
        String masterName = null;
        GridBagConstraints gconstr = null;
        Object masterObject = null;
        String[] windowNames = null;
        JComponent[] jcomponents = null;
        int modOptions = 0;
        String errMsg = null;

        Configure() {
        }

        void exec(String masterName, Object masterObject, GridBagConstraints gconstr, String[] windowNames, int modOptions) throws TclException {
            this.masterName = masterName;
            this.masterObject = masterObject;
            this.gconstr = gconstr;
            this.windowNames = windowNames;
            this.modOptions = modOptions;
            this.jcomponents = new JComponent[windowNames.length];
            for (int i = 0; i < windowNames.length; ++i) {
                String thisArg = windowNames[i];
                if (thisArg.equals("^") || thisArg.equals("-") || thisArg.equals("x")) continue;
                TclObject tObj2 = (TclObject)Widgets.getWidget(GridCmd.this.interp, thisArg);
                if (tObj2 == null) {
                    throw new TclException(GridCmd.this.interp, "bad window path name \"" + thisArg + "\"");
                }
                Object compObject = ReflectObject.get((Interp)GridCmd.this.interp, (TclObject)tObj2);
                if (compObject instanceof JComponent) {
                    this.jcomponents[i] = (JComponent)compObject;
                    continue;
                }
                throw new TclException(GridCmd.this.interp, "can't manage \"" + thisArg + "\": it's a top-level window");
            }
            this.execOnThread();
            if (this.errMsg != null) {
                throw new TclException(GridCmd.this.interp, this.errMsg);
            }
        }

        public void run() {
            this.errMsg = GridCmd.this.doit(this.masterName, this.masterObject, this.gconstr, this.windowNames, this.jcomponents, this.modOptions);
        }
    }
}

