/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GridRowColumnProps;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public class SwkGridBagLayout
extends GridBagLayout {
    boolean propagate = true;
    Hashtable columnTable = new Hashtable();
    Hashtable rowTable = new Hashtable();
    GridRowColumnProps defaultColumnProps = new GridRowColumnProps();
    GridRowColumnProps defaultRowProps = new GridRowColumnProps();
    int lastRow = 0;

    int getRCMax(boolean columnMode) {
        Iterator iter = null;
        iter = columnMode ? this.columnTable.keySet().iterator() : this.rowTable.keySet().iterator();
        int x = 0;
        while (iter.hasNext()) {
            int iKey;
            String key = (String)iter.next();
            GridRowColumnProps rcProps = null;
            rcProps = columnMode ? (GridRowColumnProps)this.columnTable.get(key) : (GridRowColumnProps)this.rowTable.get(key);
            if (rcProps.weight <= 0 && rcProps.minSize <= 0 && rcProps.pad <= 0 || (iKey = Integer.parseInt(key)) <= x) continue;
            x = iKey;
        }
        return x;
    }

    GridRowColumnProps getProps(boolean columnMode, String key, int index) {
        if (columnMode) {
            return this.getColumnProps(key, index);
        }
        return this.getRowProps(key, index);
    }

    GridRowColumnProps getColumnProps(String key, int column) {
        GridRowColumnProps columnProps = (GridRowColumnProps)this.columnTable.get(key);
        if (columnProps == null) {
            columnProps = this.defaultColumnProps;
        }
        columnProps.minSize = this.getColumnMinSize(column);
        return columnProps;
    }

    GridRowColumnProps getRowProps(String key, int row) {
        GridRowColumnProps rowProps = (GridRowColumnProps)this.rowTable.get(key);
        if (rowProps == null) {
            rowProps = this.defaultRowProps;
        }
        rowProps.minSize = this.getRowMinSize(row);
        return rowProps;
    }

    void putColumnProps(String key, GridRowColumnProps rcProps) {
        this.columnTable.put(key, rcProps);
    }

    void putRowProps(String key, GridRowColumnProps rcProps) {
        this.rowTable.put(key, rcProps);
    }

    void setMinSize(boolean columnMode, int index, int minSize) {
        if (columnMode) {
            this.setColumnMinSize(index, minSize);
        } else {
            this.setRowMinSize(index, minSize);
        }
    }

    void setColumnMinSize(int column, int minSize) {
        if (this.columnWidths == null) {
            this.columnWidths = new int[column + 2];
        } else if (this.columnWidths.length <= column) {
            int[] newWidths = new int[column + 2];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                newWidths[i] = this.columnWidths[i];
            }
            this.columnWidths = newWidths;
        }
        this.columnWidths[column] = minSize;
    }

    void setRowMinSize(int column, int minSize) {
        if (this.rowHeights == null) {
            this.rowHeights = new int[column + 2];
        } else if (this.rowHeights.length <= column) {
            int[] newHeights = new int[column + 2];
            for (int i = 0; i < this.rowHeights.length; ++i) {
                newHeights[i] = this.rowHeights[i];
            }
            this.rowHeights = newHeights;
        }
        this.rowHeights[column] = minSize;
    }

    int getMinSize(boolean columnMode, int index) {
        if (columnMode) {
            return this.getColumnMinSize(index);
        }
        return this.getRowMinSize(index);
    }

    int getColumnMinSize(int column) {
        if (this.columnWidths == null) {
            return 0;
        }
        if (this.columnWidths.length <= column) {
            return 0;
        }
        return this.columnWidths[column];
    }

    int getRowMinSize(int column) {
        if (this.rowHeights == null) {
            return 0;
        }
        if (this.rowHeights.length <= column) {
            return 0;
        }
        return this.rowHeights[column];
    }

    void setWeight(boolean columnMode, int index, int weight) {
        if (columnMode) {
            this.setColumnWeight(index, weight);
        } else {
            this.setRowWeight(index, weight);
        }
    }

    void setColumnWeight(int column, int weight) {
        if (this.columnWeights == null) {
            this.columnWeights = new double[column + 2];
        } else if (this.columnWeights.length <= column) {
            double[] newWeights = new double[column + 2];
            for (int i = 0; i < this.columnWeights.length; ++i) {
                newWeights[i] = this.columnWeights[i];
            }
            this.columnWeights = newWeights;
        }
        this.columnWeights[column] = weight;
    }

    void setRowWeight(int row, int weight) {
        if (this.rowWeights == null) {
            this.rowWeights = new double[row + 2];
        } else if (this.rowWeights.length <= row) {
            double[] newWeights = new double[row + 2];
            for (int i = 0; i < this.rowWeights.length; ++i) {
                newWeights[i] = this.rowWeights[i];
            }
            this.rowWeights = newWeights;
        }
        this.rowWeights[row] = weight;
    }

    public Dimension maximumLayoutSize(Container target) {
        return super.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return super.getLayoutAlignmentX(target);
    }

    public float getLayoutAlignmentY(Container target) {
        return super.getLayoutAlignmentY(target);
    }

    public void invalidateLayout(Container target) {
        super.invalidateLayout(target);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
    }

    public void addLayoutComponent(Component comp, String constraints) {
        super.addLayoutComponent(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
        GridBagConstraints gconstr = this.getConstraints(comp);
        if (gconstr != null) {
            // empty if block
        }
        super.removeLayoutComponent(comp);
    }

    public Dimension preferredLayoutSize(Container target) {
        return super.preferredLayoutSize(target);
    }

    public Dimension minimumLayoutSize(Container target) {
        JRootPane jroot;
        Insets insets = target.getInsets();
        Container target2 = target;
        Dimension cdim = null;
        if (target instanceof JComponent && (jroot = ((JComponent)target).getRootPane()) != null) {
            target2 = jroot.getParent();
        }
        cdim = super.minimumLayoutSize(target);
        return cdim;
    }

    public void layoutContainer(Container target) {
        super.layoutContainer(target);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

