/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SymbolInterface;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SymbolParameter
extends CanvasParameter {
    private static String name = "symbol";
    private static int defValue = 3;
    private int newValue = defValue;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-symbol".startsWith(s);
    }

    public int parseSymbolType(String symbolName) {
        int symbolType = -1;
        if ("none".startsWith(symbolName)) {
            symbolType = -1;
        } else if ("circle".startsWith(symbolName)) {
            symbolType = 0;
        } else if ("triangle_up".startsWith(symbolName)) {
            symbolType = 1;
        } else if ("triangle_down".startsWith(symbolName)) {
            symbolType = 2;
        } else if ("cross".startsWith(symbolName)) {
            symbolType = 3;
        } else if ("square".startsWith(symbolName)) {
            symbolType = 4;
        } else if ("diamond".startsWith(symbolName)) {
            symbolType = 5;
        }
        return symbolType;
    }

    public static String getSymbolType(int symbolType) {
        switch (symbolType) {
            case -1: {
                return "none";
            }
            case 0: {
                return "circle";
            }
            case 1: {
                return "uptriangle";
            }
            case 2: {
                return "downtriangle";
            }
            case 3: {
                return "cross";
            }
            case 4: {
                return "square";
            }
            case 5: {
                return "diamond";
            }
        }
        return "";
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        String symbolType = "";
        if (swkShape != null && swkShape instanceof SymbolInterface) {
            symbolType = ((SymbolInterface)((Object)swkShape)).getSymbolType();
        }
        return TclString.newInstance((String)symbolType);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = -1;
        if (arg != null && arg.toString().length() > 0) {
            this.newValue = Character.isDigit(arg.toString().charAt(0)) ? TclInteger.get((Interp)interp, (TclObject)arg) : this.parseSymbolType(arg.toString());
        }
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof SymbolInterface) {
            ((SymbolInterface)((Object)swkShape)).setSymbolType(this.newValue);
        }
    }
}

