/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TextInterface;
import java.awt.Color;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class TextcolorParameter
extends CanvasParameter {
    private static String name = "textcolor";
    private static Color defValue = null;
    private Color newValue = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-textcolor".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        Color colorVal = swkShape instanceof TextInterface ? ((TextInterface)((Object)swkShape)).getTextColor() : swkShape.fill;
        return TclString.newInstance((String)SwankUtil.parseColor(colorVal));
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = SwankUtil.getColor(interp, arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            if (swkShape instanceof TextInterface) {
                ((TextInterface)((Object)swkShape)).setTextColor(this.newValue);
            } else {
                swkShape.fill = this.newValue;
            }
        }
    }
}

