/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlNumber;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlInt64
extends OCamlValue
implements OCamlNumber {
    public static final Wrapper<OCamlInt64> WRAPPER = new SimpleWrapper<OCamlInt64>(){

        @Override
        public OCamlInt64 wrap(Value v) {
            return new OCamlInt64(v);
        }
    };

    private OCamlInt64(Value v) {
        super(v);
    }

    public Wrapper<? extends OCamlInt64> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        return OCamlUnit.WRAPPER;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value.asInt64();
    }

    @Override
    public double doubleValue() {
        return this.value.asInt64();
    }

    @Override
    public float floatValue() {
        return this.value.asInt64();
    }

    @Override
    public int intValue() {
        return (int)this.value.asInt64();
    }

    @Override
    public long longValue() {
        return this.value.asInt64();
    }

    @Override
    public short shortValue() {
        return (short)this.value.asInt64();
    }

    @Override
    public int hashCode() {
        return (int)this.value.asInt64();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlInt64) {
            OCamlInt64 that = (OCamlInt64)obj;
            return this.value.asInt64() == that.value.asInt64();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlInt64(");
        sb.append(this.value.asInt64());
        sb.append(")");
        return sb.toString();
    }

    public static OCamlInt64 create(long v) {
        return new OCamlInt64(Value.createInt64(v));
    }

    public static OCamlInt64 wrap(Value v) {
        assert (v != null) : "null v";
        return new OCamlInt64(v);
    }

    public static Wrapper<? extends OCamlInt64> wrapper() {
        return WRAPPER;
    }
}

