/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkJTable;
import com.onemoonscientific.swank.SwkTableModel;
import com.onemoonscientific.swank.TableSorter;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJTableWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "sort", "column", "rowforindex", "indexforrow", "update", "set", "get", "mset", "mget", "setmodel", "selection", "showrow", "columnatpoint", "rowatpoint", "convertcolumnindextomodel", "columnwidth", "columnresizable"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_SORT = 2;
    private static final int OPT_COLUMN = 3;
    private static final int OPT_ROWFORINDEX = 4;
    private static final int OPT_INDEXFORROW = 5;
    private static final int OPT_UPDATE = 6;
    private static final int OPT_SET = 7;
    private static final int OPT_GET = 8;
    private static final int OPT_MSET = 9;
    private static final int OPT_MGET = 10;
    private static final int OPT_SETMODEL = 11;
    private static final int OPT_SELECTION = 12;
    private static final int OPT_SHOWROW = 13;
    private static final int OPT_COLUMNATPOINT = 14;
    private static final int OPT_ROWATPOINT = 15;
    private static final int OPT_CONVERTCOLUMNINDEXTOMODEL = 16;
    private static final int OPT_COLUMNWIDTH = 17;
    private static final int OPT_COLUMNRESIZABLE = 18;
    static boolean gotDefaults = false;
    int index;
    Interp interp = null;

    SwkJTableWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        this.interp = interp;
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJTable swkjtable = (SwkJTable)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjtable.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjtable.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjtable.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjtable.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJTable.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjtable.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.sort(interp, swkjtable, argv);
                break;
            }
            case 3: {
                this.column(interp, swkjtable, argv);
                break;
            }
            case 4: {
                this.rowForIndex(interp, swkjtable, argv);
                break;
            }
            case 5: {
                this.indexForRow(interp, swkjtable, argv);
                break;
            }
            case 6: {
                this.update(interp, swkjtable, argv);
                break;
            }
            case 7: {
                this.set(interp, swkjtable, argv, true);
                break;
            }
            case 9: {
                this.set(interp, swkjtable, argv, false);
                break;
            }
            case 8: {
                this.get(interp, swkjtable, argv, true);
                break;
            }
            case 10: {
                this.get(interp, swkjtable, argv, false);
                break;
            }
            case 11: {
                this.setModel(interp, swkjtable, argv);
                break;
            }
            case 12: {
                this.selection(interp, swkjtable, argv);
                break;
            }
            case 13: {
                this.showRow(interp, swkjtable, argv);
                break;
            }
            case 14: {
                this.rowOrColumnAtPoint(interp, swkjtable, argv, false);
                break;
            }
            case 15: {
                this.rowOrColumnAtPoint(interp, swkjtable, argv, true);
                break;
            }
            case 16: {
                this.convertColumnIndexToModel(interp, swkjtable, argv);
                break;
            }
            case 17: {
                this.columnWidth(interp, swkjtable, argv);
                break;
            }
            case 18: {
                this.columnResizable(interp, swkjtable, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void sort(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "?-descending|-ascending? ?-date? column");
        }
        int iCol = 0;
        int status = 0;
        String sortMode = null;
        iCol = TclInteger.get((Interp)interp, (TclObject)argv[argv.length - 1]);
        for (int iArg = 2; iArg < argv.length - 1; ++iArg) {
            if (argv[iArg].toString().startsWith("-desc")) {
                status = -1;
                continue;
            }
            if (argv[iArg].toString().startsWith("-asc")) {
                status = 1;
                continue;
            }
            if (argv[iArg].toString().startsWith("-date")) {
                sortMode = "date";
                continue;
            }
            throw new TclException(interp, "sort: invalid option");
        }
        new Sort().exec(swkjtable, iCol, status, sortMode);
    }

    void column(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int iCol = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        Object colClass = ReflectObject.get((Interp)interp, (TclObject)argv[3]);
        if (!(colClass instanceof Class)) {
            throw new TclException(interp, "must provide class");
        }
        new Column().exec(swkjtable, iCol, colClass);
    }

    void rowForIndex(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int index = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int row = new Row().exec(swkjtable, index, true);
        interp.setResult(row);
    }

    void indexForRow(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int row = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int index = new Row().exec(swkjtable, row, false);
        interp.setResult(index);
    }

    void update(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length > 3) {
            throw new TclNumArgsException(interp, 2, argv, "?data?");
        }
        if (argv.length == 3 && argv[2].toString().equals("data")) {
            new Update().data(swkjtable);
        } else {
            new Update().structure(swkjtable);
        }
    }

    void set(Interp interp, SwkJTable swkjtable, TclObject[] argv, boolean useSorted) throws TclException {
        if (argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int iRow = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int iCol = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        new Set().exec(swkjtable, iRow, iCol, useSorted, argv[4]);
    }

    void get(Interp interp, SwkJTable swkjtable, TclObject[] argv, boolean useSorted) throws TclException {
        int iCol;
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int iRow = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        Object tblObject = new Get().exec(swkjtable, iRow, iCol = TclInteger.get((Interp)interp, (TclObject)argv[3]), useSorted);
        if (tblObject == null) {
            interp.setResult("");
        } else if (tblObject instanceof TclObject) {
            interp.setResult((TclObject)tblObject);
        } else if (tblObject instanceof Color) {
            interp.setResult(SwankUtil.parseColor((Color)tblObject));
        } else if (tblObject instanceof Boolean) {
            interp.setResult(((Boolean)tblObject).booleanValue());
        } else {
            interp.setResult(tblObject.toString());
        }
    }

    void setModel(Interp interp, final SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "model");
        }
        final SwkTableModel tableModel = (SwkTableModel)ReflectObject.get((Interp)interp, (TclObject)argv[2]);
        if (tableModel == null) {
            throw new TclException(interp, "in setmodel: tableModel null");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TableModel currentModel = swkjtable.getModel();
                    if (currentModel instanceof TableSorter) {
                        ((TableSorter)currentModel).setTableModel(tableModel);
                    } else {
                        swkjtable.setModel(tableModel);
                    }
                    swkjtable.swkTableModel = tableModel;
                }
            });
        }
        catch (Exception e) {
            throw new TclException(interp, e.getMessage());
        }
    }

    void selection(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 5) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        if (argv[2].toString().equals("countrows")) {
            int nSelected = new SelectionGet().countRows(swkjtable);
            interp.setResult(nSelected);
        } else if (argv[2].toString().equals("clear")) {
            new SelectionSet().clear(swkjtable);
        } else if (argv[2].toString().equals("addrow")) {
            int first;
            if (argv.length != 4 && argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "first ? last ?");
            }
            int last = first = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            if (argv.length == 5) {
                last = TclInteger.get((Interp)interp, (TclObject)argv[4]);
            }
            new SelectionSet().set(swkjtable, first, last);
        } else if (argv[2].toString().equals("getrows")) {
            int[] srows = new SelectionGet().getRows(swkjtable);
            TclObject tList = TclList.newInstance();
            if (srows != null) {
                for (int i = 0; i < srows.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)tList, (TclObject)TclInteger.newInstance((int)srows[i]));
                }
            }
            interp.setResult(tList);
        }
    }

    void showRow(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        int row1;
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "index1 ?index2?");
        }
        int row2 = row1 = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        if (argv.length == 4) {
            row2 = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        }
        new ShowRow().exec(swkjtable, row1, row2);
    }

    void rowOrColumnAtPoint(Interp interp, SwkJTable swkjtable, TclObject[] argv, boolean rowMode) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "x y");
        }
        int x = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        int value = new RowOrColumnAtPoint().exec(swkjtable, x, y, rowMode);
        interp.setResult(value);
    }

    void convertColumnIndexToModel(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "column");
        }
        int column = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int value = new ConvertColumn().exec(swkjtable, column);
        interp.setResult(value);
    }

    void columnWidth(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "column");
        }
        int column = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int width = 0;
        if (argv.length == 4) {
            width = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            new SetColumnWidth().exec(swkjtable, column, width);
        } else {
            width = new GetColumnWidth().exec(swkjtable, column);
        }
        interp.setResult(width);
    }

    void columnResizable(Interp interp, SwkJTable swkjtable, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "column");
        }
        int column = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        boolean resizable = false;
        if (argv.length == 4) {
            resizable = TclBoolean.get((Interp)interp, (TclObject)argv[3]);
            new SetColumnResizable().exec(swkjtable, column, resizable);
        } else {
            resizable = new GetColumnResizable().exec(swkjtable, column);
        }
        interp.setResult(resizable);
    }

    class GetColumnResizable
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int column = 0;
        boolean resizable = false;

        GetColumnResizable() {
        }

        boolean exec(SwkJTable swkjtable, int column) {
            this.swkjtable = swkjtable;
            this.column = column;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.resizable;
        }

        public void run() {
            TableColumnModel cM = this.swkjtable.getColumnModel();
            if (this.column < cM.getColumnCount()) {
                TableColumn tableColumn = cM.getColumn(this.column);
                this.resizable = tableColumn.getResizable();
            }
        }
    }

    class SetColumnResizable
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int column = 0;
        boolean resizable = false;

        SetColumnResizable() {
        }

        void exec(SwkJTable swkjtable, int column, boolean resizable) {
            this.column = column;
            this.resizable = resizable;
            this.swkjtable = swkjtable;
            this.execOnThread();
        }

        public void run() {
            TableColumnModel cM = this.swkjtable.getColumnModel();
            if (this.column < cM.getColumnCount()) {
                TableColumn tableColumn = cM.getColumn(this.column);
                tableColumn.setResizable(this.resizable);
            }
        }
    }

    class GetColumnWidth
    extends GetValueOnEventThread {
        SwkJTable swkjtable = null;
        int column = 0;
        int width = 0;

        GetColumnWidth() {
        }

        int exec(SwkJTable swkjtable, int column) {
            this.column = column;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.width;
        }

        public void run() {
            TableColumnModel cM = this.swkjtable.getColumnModel();
            if (this.column < cM.getColumnCount()) {
                TableColumn tableColumn = cM.getColumn(this.column);
                this.width = tableColumn.getWidth();
            }
        }
    }

    class SetColumnWidth
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int column = 0;
        int width = 0;

        SetColumnWidth() {
        }

        void exec(SwkJTable swkjtable, int column, int width) {
            this.column = column;
            this.width = width;
            this.swkjtable = swkjtable;
            this.execOnThread();
        }

        public void run() {
            TableColumnModel cM = this.swkjtable.getColumnModel();
            if (this.column < cM.getColumnCount()) {
                TableColumn tableColumn = cM.getColumn(this.column);
                tableColumn.setPreferredWidth(this.width);
                if (this.width == 0) {
                    tableColumn.setMinWidth(this.width);
                    tableColumn.setMaxWidth(this.width);
                }
                tableColumn.setWidth(this.width);
            }
        }
    }

    class RowOrColumnAtPoint
    extends GetValueOnEventThread {
        SwkJTable swkjtable = null;
        int x = 0;
        int y = 0;
        boolean rowMode = false;
        int result = 0;

        RowOrColumnAtPoint() {
        }

        int exec(SwkJTable swkjtable, int x, int y, boolean rowMode) {
            this.x = x;
            this.y = y;
            this.rowMode = rowMode;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            if (this.rowMode) {
                this.result = this.swkjtable.rowAtPoint(new Point(this.x, this.y));
            } else {
                this.result = this.swkjtable.columnAtPoint(new Point(this.x, this.y));
                this.result = this.swkjtable.convertColumnIndexToModel(this.result);
            }
        }
    }

    class ConvertColumn
    extends GetValueOnEventThread {
        SwkJTable swkjtable = null;
        int column = 0;
        int result = 0;

        ConvertColumn() {
        }

        int exec(SwkJTable swkjtable, int column) {
            this.column = column;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = this.swkjtable.convertColumnIndexToModel(this.column);
        }
    }

    class ShowRow
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int row1 = 0;
        int row2 = 0;

        ShowRow() {
        }

        void exec(SwkJTable swkjtable, int row1, int row2) {
            this.swkjtable = swkjtable;
            this.row1 = row1;
            this.row2 = row2;
            this.execOnThread();
        }

        public void run() {
            Rectangle rect1 = this.swkjtable.getCellRect(this.row1, 0, true);
            Rectangle rect2 = this.swkjtable.getCellRect(this.row2, 0, true);
            rect1.add(rect2);
            this.swkjtable.scrollRectToVisible(rect1);
        }
    }

    class SelectionGet
    extends GetValueOnEventThread {
        static final int COUNT_ROWS = 0;
        static final int GET_ROWS = 1;
        SwkJTable swkjtable = null;
        int mode = 0;
        int nSelected = 0;
        int[] selectedRows = null;

        SelectionGet() {
        }

        int countRows(SwkJTable swkjtable) {
            this.swkjtable = swkjtable;
            this.mode = 0;
            this.execOnThread();
            return this.nSelected;
        }

        int[] getRows(SwkJTable swkjtable) {
            this.swkjtable = swkjtable;
            this.mode = 1;
            this.execOnThread();
            return this.selectedRows;
        }

        public void run() {
            if (this.mode == 0) {
                this.nSelected = this.swkjtable.getSelectedRowCount();
            } else if (this.mode == 1) {
                this.selectedRows = this.swkjtable.getSelectedRows();
            } else {
                System.out.println("invalid option to SelectionGet");
            }
        }
    }

    class SelectionSet
    extends UpdateOnEventThread {
        static final int CLEAR = 0;
        static final int SET = 1;
        SwkJTable swkjtable = null;
        int first = 0;
        int last = 0;
        int mode = 0;

        SelectionSet() {
        }

        void set(SwkJTable swkjtable, int first, int last) {
            this.swkjtable = swkjtable;
            this.first = first;
            this.last = last;
            this.mode = 1;
            this.execOnThread();
        }

        void clear(SwkJTable swkjtable) {
            this.swkjtable = swkjtable;
            this.mode = 0;
            this.execOnThread();
        }

        public void run() {
            int nRows = this.swkjtable.getRows();
            if (this.mode == 1) {
                if (this.first > this.last) {
                    int hold = this.first;
                    this.first = this.last;
                    this.last = hold;
                }
                if (nRows == 0) {
                    return;
                }
                if (this.last > nRows) {
                    this.last = nRows - 1;
                }
                if (this.first > nRows) {
                    this.first = nRows - 1;
                }
                if (this.last < 0) {
                    this.last = 0;
                }
                if (this.first < 0) {
                    this.first = 0;
                }
                this.swkjtable.addRowSelectionInterval(this.first, this.last);
            } else if (this.mode == 0) {
                if (nRows == 0) {
                    return;
                }
                this.swkjtable.clearSelection();
            } else {
                System.out.println("invalid option to SelectionSet");
            }
        }
    }

    class Get
    extends GetValueOnEventThread {
        SwkJTable swkjtable = null;
        int iRow = 0;
        int iCol = 0;
        boolean useSorted = false;
        Object tblObject = null;

        Get() {
        }

        Object exec(SwkJTable swkjtable, int iRow, int iCol, boolean useSorted) {
            this.iRow = iRow;
            this.iCol = iCol;
            this.useSorted = useSorted;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.tblObject;
        }

        public void run() {
            if (this.useSorted) {
                this.tblObject = this.swkjtable.getModel().getValueAt(this.iRow, this.iCol);
            } else {
                TableModel currentModel;
                TableModel nonSortModel = currentModel = this.swkjtable.getModel();
                if (currentModel instanceof TableSorter) {
                    nonSortModel = ((TableSorter)currentModel).getTableModel();
                }
                this.tblObject = nonSortModel.getValueAt(this.iRow, this.iCol);
            }
        }
    }

    class Set
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int iRow = 0;
        int iCol = 0;
        boolean useSorted = false;
        TclObject value = null;

        Set() {
        }

        void exec(SwkJTable swkjtable, int iRow, int iCol, boolean useSorted, TclObject value) {
            this.iRow = iRow;
            this.iCol = iCol;
            this.value = value.duplicate();
            this.useSorted = useSorted;
            this.swkjtable = swkjtable;
            this.execOnThread();
        }

        public void run() {
            if (this.useSorted) {
                this.swkjtable.getModel().setValueAt(this.value, this.iRow, this.iCol);
            } else {
                TableModel currentModel;
                TableModel nonSortModel = currentModel = this.swkjtable.getModel();
                if (currentModel instanceof TableSorter) {
                    nonSortModel = ((TableSorter)currentModel).getTableModel();
                }
                nonSortModel.setValueAt(this.value, this.iRow, this.iCol);
            }
        }
    }

    class Update
    extends UpdateOnEventThread {
        static final int DATA = 0;
        static final int STRUCTURE = 1;
        SwkJTable swkjtable = null;
        int mode = 0;

        Update() {
        }

        void structure(SwkJTable swkjtable) {
            this.swkjtable = swkjtable;
            this.mode = 1;
            this.execOnThread();
        }

        void data(SwkJTable swkjtable) {
            this.swkjtable = swkjtable;
            this.mode = 0;
            this.execOnThread();
        }

        public void run() {
            if (this.mode == 0) {
                this.swkjtable.swkTableModel.fireTableChanged(new TableModelEvent(this.swkjtable.swkTableModel));
            } else {
                this.swkjtable.swkTableModel.fireTableStructureChanged();
            }
        }
    }

    class Row
    extends GetValueOnEventThread {
        SwkJTable swkjtable = null;
        int inVal = 0;
        boolean rowForIndex = false;
        int result = 0;

        Row() {
        }

        int exec(SwkJTable swkjtable, int inVal, boolean rowForIndex) {
            this.inVal = inVal;
            this.rowForIndex = rowForIndex;
            this.swkjtable = swkjtable;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = this.rowForIndex ? ((TableSorter)this.swkjtable.getModel()).modelIndex(this.inVal) : ((TableSorter)this.swkjtable.getModel()).viewIndex(this.inVal);
        }
    }

    class Column
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int iCol = 0;
        Object colClass = null;

        Column() {
        }

        void exec(SwkJTable swkjtable, int iCol, Object colClass) {
            this.swkjtable = swkjtable;
            this.iCol = iCol;
            this.colClass = colClass;
            this.execOnThread();
        }

        public void run() {
            this.swkjtable.swkTableModel.setColumnClass(SwkJTableWidgetCmd.this.interp, this.iCol, (Class)this.colClass);
        }
    }

    class Sort
    extends UpdateOnEventThread {
        SwkJTable swkjtable = null;
        int iCol = 0;
        int status = 0;
        String sortMode = null;

        Sort() {
        }

        void exec(SwkJTable swkjtable, int iCol, int status, String sortMode) {
            this.swkjtable = swkjtable;
            this.iCol = iCol;
            this.status = status;
            this.sortMode = sortMode;
            this.execOnThread();
        }

        public void run() {
            ((TableSorter)this.swkjtable.getModel()).setSortingStatus(this.iCol, this.status);
        }
    }
}

