/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ForkJoinPool", source="")
public final class ForkJoinPool {
    private ForkJoinPool() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "bool"}, returnType="ForkJoinPool.t")
    public static Value ocamljava_forkjoinpool_make(Value value, Value value2) throws Fail.Exception {
        try {
            java.util.concurrent.ForkJoinPool forkJoinPool;
            ForkJoinThreadFactory forkJoinThreadFactory = new ForkJoinThreadFactory(OCamlJavaThread.getCodeRunner());
            forkJoinPool(value.asInt32(), forkJoinThreadFactory, null, value2 != Value.FALSE);
            java.util.concurrent.ForkJoinPool forkJoinPool2 = forkJoinPool;
            return Value.createInstance(forkJoinPool2);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ForkJoinPool.make");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "int64", "TimeUnit.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_await_termination(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        try {
            Value value4;
            if (forkJoinPool.awaitTermination(value2.asInt64(), TimeUnit.decode(value3))) {
                value4 = Value.TRUE;
                return value4;
            }
            value4 = Value.FALSE;
            return value4;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ForkJoinPool.await_termination");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_active_thread_count(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt32(forkJoinPool.getActiveThreadCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_get_async_mode(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.getAsyncMode() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_parallelism(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt32(forkJoinPool.getParallelism());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_pool_size(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt32(forkJoinPool.getPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_queued_submission_count(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt32(forkJoinPool.getQueuedSubmissionCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int64")
    public static Value ocamljava_forkjoinpool_get_queued_task_count(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt64(forkJoinPool.getQueuedTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_running_thread_count(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt32(forkJoinPool.getRunningThreadCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int64")
    public static Value ocamljava_forkjoinpool_get_steal_count(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return Value.createInt64(forkJoinPool.getStealCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_has_queued_submissions(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.hasQueuedSubmissions() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_quiescent(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.isQuiescent() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_shutdown(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.isShutdown() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_terminated(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.isTerminated() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_terminating(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        return forkJoinPool.isTerminating() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="unit")
    public static Value ocamljava_forkjoinpool_shutdown(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        forkJoinPool.shutdown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="unit")
    public static Value ocamljava_forkjoinpool_shutdown_now(Value value) {
        java.util.concurrent.ForkJoinPool forkJoinPool = (java.util.concurrent.ForkJoinPool)value.asCustom();
        forkJoinPool.shutdownNow();
        return Value.UNIT;
    }
}

