/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.RejectedExecutionHandler;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadPoolExecutor", source="")
public final class ThreadPoolExecutor {
    private ThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static Value ocamljava_threadpoolexecutor_make(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception {
        try {
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
            ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
            java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = new java.util.concurrent.ThreadPoolExecutor(value.asInt32(), value2.asInt32(), value3.asInt64(), TimeUnit.decode(value4), linkedBlockingQueue, threadFactory, RejectedExecutionHandler.decode(value5));
            return Value.createInstance(threadPoolExecutor);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.make");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_await_termination(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        try {
            Value value4;
            if (threadPoolExecutor.awaitTermination(value2.asInt64(), TimeUnit.decode(value3))) {
                value4 = Value.TRUE;
                return value4;
            }
            value4 = Value.FALSE;
            return value4;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.await_termination");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_active_count(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt32(threadPoolExecutor.getActiveCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_completed_task_count(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt64(threadPoolExecutor.getCompletedTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_core_pool_size(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt32(threadPoolExecutor.getCorePoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "TimeUnit.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_keep_alive_time(Value value, Value value2) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt64(threadPoolExecutor.getKeepAliveTime(TimeUnit.decode(value2)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_largest_pool_size(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt32(threadPoolExecutor.getLargestPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_maximum_pool_size(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt32(threadPoolExecutor.getMaximumPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int32")
    public static Value ocamljava_threadpoolexecutor_get_pool_size(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt32(threadPoolExecutor.getPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="RejectedExecutionHandler.t")
    public static Value ocamljava_threadpoolexecutor_get_rejected_execution_handler(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return RejectedExecutionHandler.encode(threadPoolExecutor.getRejectedExecutionHandler());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="int64")
    public static Value ocamljava_threadpoolexecutor_get_task_count(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInt64(threadPoolExecutor.getTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all(Value value, Value value2) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        try {
            return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list));
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_all");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        try {
            return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list, value3.asInt64(), TimeUnit.decode(value4)));
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_all_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any(Value value, Value value2) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        try {
            return threadPoolExecutor.invokeAny(list);
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_any");
            return Value.UNIT;
        }
        catch (ExecutionException executionException) {
            Fail.failWith("Concurrent.ThreadPoolExecutor.invoke_any");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        try {
            return threadPoolExecutor.invokeAny(list, value3.asInt64(), TimeUnit.decode(value4));
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
        catch (ExecutionException executionException) {
            Fail.failWith("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
        catch (TimeoutException timeoutException) {
            Runtime.raiseTimeout("Concurrent.ThreadPoolExecutor.invoke_any_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_shutdown(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return threadPoolExecutor.isShutdown() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_terminated(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return threadPoolExecutor.isTerminated() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="bool")
    public static Value ocamljava_threadpoolexecutor_is_terminating(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return threadPoolExecutor.isTerminating() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_core_pool_size(Value value, Value value2) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        try {
            threadPoolExecutor.setCorePoolSize(value2.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_core_pool_size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_keep_alive_time(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        try {
            threadPoolExecutor.setKeepAliveTime(value2.asInt64(), TimeUnit.decode(value3));
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_keep_alive_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_maximum_pool_size(Value value, Value value2) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        try {
            threadPoolExecutor.setMaximumPoolSize(value2.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.ThreadPoolExecutor.set_maximum_pool_size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "RejectedExecutionHandler.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_set_rejected_execution_handler(Value value, Value value2) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        threadPoolExecutor.setRejectedExecutionHandler(RejectedExecutionHandler.decode(value2));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="unit")
    public static Value ocamljava_threadpoolexecutor_shutdown(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        threadPoolExecutor.shutdown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return ThreadPoolExecutor.encodeRunnableList(threadPoolExecutor.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Value ocamljava_threadpoolexecutor_submit(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        try {
            return Value.createInstance(threadPoolExecutor.submit(new FutureCallable(value2, value3)));
        }
        catch (Throwable throwable) {
            Fail.failWith("ThreadPoolExecutor.submit");
            return Value.UNIT;
        }
    }

    static List<Callable<Value>> decodeCallableList(Value value) {
        LinkedList<Callable<Value>> linkedList = new LinkedList<Callable<Value>>();
        Value value2 = value;
        while (value2.isBlock()) {
            linkedList.add(new FutureCallable(value2.get0(), Value.UNIT));
            value2 = value2.get1();
        }
        return linkedList;
    }

    static Value encodeFutureList(List<Future<Value>> list) {
        Value value = Value.EMPTY_LIST;
        ListIterator<Future<Value>> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            value = Value.createBlock(0, Value.createInstance(listIterator.previous()), value);
        }
        return value;
    }

    static Value encodeRunnableList(List<Runnable> list) {
        Value value = Value.EMPTY_LIST;
        ListIterator<Runnable> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Runnable runnable = listIterator.previous();
            if (!(runnable instanceof RunnableFuture)) continue;
            value = Value.createBlock(0, Value.createInstance(runnable), value);
        }
        return value;
    }
}

