/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ShellUtils {
    private ShellUtils() {
    }

    public static String[] prepareArguments(String[] stringArray) {
        assert (stringArray != null) : "null args";
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            int n2 = string.length();
            if (n2 >= 2) {
                char c = string.charAt(0);
                int n3 = n2 - 1;
                stringArray2[i] = n3 >= 0 && (c == '\'' || c == '\"') && c == string.charAt(n3) ? string.substring(1, n3) : string;
                continue;
            }
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    public static List<String> parseCommandLine(String string) {
        assert (string != null) : "null s";
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        ParserState parserState = ParserState.NORMAL;
        int n = string.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (parserState) {
                case NORMAL: {
                    switch (c) {
                        case ' ': {
                            if (stringBuilder.length() > 0) {
                                linkedList.add(stringBuilder.toString());
                            }
                            stringBuilder = new StringBuilder();
                            continue block12;
                        }
                        case '\\': {
                            parserState = ParserState.ESCAPED;
                            continue block12;
                        }
                        case '\'': {
                            parserState = ParserState.SINGLE_QUOTE;
                            continue block12;
                        }
                        case '\"': {
                            parserState = ParserState.DOUBLE_QUOTE;
                            continue block12;
                        }
                    }
                    stringBuilder.append(c);
                    continue block12;
                }
                case SINGLE_QUOTE: {
                    if (c == '\'') {
                        parserState = ParserState.NORMAL;
                        continue block12;
                    }
                    stringBuilder.append(c);
                    continue block12;
                }
                case DOUBLE_QUOTE: {
                    if (c == '\"') {
                        parserState = ParserState.NORMAL;
                        continue block12;
                    }
                    stringBuilder.append(c);
                    continue block12;
                }
                case ESCAPED: {
                    parserState = ParserState.NORMAL;
                    stringBuilder.append(c);
                    continue block12;
                }
                default: {
                    assert (false) : "invalid state";
                    continue block12;
                }
            }
        }
        if (stringBuilder.length() > 0) {
            linkedList.add(stringBuilder.toString());
        }
        return linkedList;
    }

    public static String[] expandCommandLine(File file, String[] stringArray) throws IOException {
        assert (file != null) : "null directory";
        assert (file.exists() && file.isDirectory()) : "directory should be an existing directory";
        assert (stringArray != null) : "null args";
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : stringArray) {
            ShellUtils.expandArgument(file, string, linkedList);
        }
        String[] stringArray2 = new String[linkedList.size()];
        return linkedList.toArray(stringArray2);
    }

    private static void expandArgument(File file, String string, List<String> list) throws IOException {
        assert (file != null) : "null dir";
        assert (file.exists() && file.isDirectory()) : "dir should be an existing directory";
        assert (string != null) : "null arg";
        assert (list != null) : "null list";
        int n = string.length();
        if (string.indexOf(42) > -1 || string.indexOf(63) > -1) {
            ShellUtils.expandPattern(file, string, list);
        } else {
            list.add(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void expandPattern(File file, String string, List<String> list) throws IOException {
        assert (file != null) : "null dir";
        assert (file.exists() && file.isDirectory()) : "dir should be an existing directory";
        assert (string != null) : "null patt";
        assert (list != null) : "null list";
        try {
            Pattern pattern = ShellUtils.compilePattern(string);
            for (String string2 : file.list()) {
                if (!pattern.matcher(string2).matches()) continue;
                list.add(string2);
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            list.add(string);
        }
    }

    private static Pattern compilePattern(String string) throws PatternSyntaxException {
        assert (string != null) : "null s";
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuilder.append(".*");
                    continue block5;
                }
                case '?': {
                    stringBuilder.append(".");
                    continue block5;
                }
                case '.': {
                    stringBuilder.append("\\.");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return Pattern.compile(stringBuilder.toString());
    }

    private static enum ParserState {
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        ESCAPED;

    }
}

