/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/access.c")
public final class Access {
    private static final int READ_OK = 4;
    private static final int WRITE_OK = 2;
    private static final int EXEC_OK = 1;
    private static final int FILE_OK = 0;
    private static final int[] TABLE = new int[]{4, 2, 1, 0};

    private Access() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "Unix.access_permission list"}, returnType="unit")
    public static Value unix_access(Value value, Value value2) throws Fail.Exception {
        int n = Misc.convertFlagList(value2, TABLE);
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        boolean bl = false;
        if ((n & 0) != 0) {
            bl |= !file.exists();
        }
        if ((n & 4) != 0) {
            bl |= !file.canRead();
        }
        if ((n & 2) != 0) {
            bl |= !file.canWrite();
        }
        if ((n & 1) != 0) {
            bl |= !file.canExecute();
        }
        if (bl) {
            Unix.fail("access", "requested file permissions not granted");
        }
        return Value.UNIT;
    }
}

