/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ocamljava.runtime.util.IntegerUtils;

public final class IO {
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTE_MASK = 255;

    private IO() {
    }

    public static int read8u(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readUnsignedByte();
    }

    public static int read8s(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readByte();
    }

    public static int read16u(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readUnsignedShort();
    }

    public static int read16s(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readShort();
    }

    public static long read32u(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return IntegerUtils.signedToUnsigned(in.readInt());
    }

    public static int read32s(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readInt();
    }

    public static long read64s(DataInput in) throws IOException {
        assert (in != null) : "null in";
        return in.readLong();
    }

    public static void write8u(DataOutput out, int val) throws IOException {
        assert (out != null) : "null out";
        assert (val >= 0 && val <= 255) : "val should be in 0..255";
        out.write(val);
    }

    public static void write8s(DataOutput out, int val) throws IOException {
        assert (out != null) : "null out";
        assert (val >= -128 && val <= 127) : "val should be in -128..127";
        out.writeByte(val);
    }

    public static void write16u(DataOutput out, int val) throws IOException {
        assert (out != null) : "null out";
        assert (val >= 0 && val <= 65535) : "val should be in 0..65535";
        out.write(0xFF & val >> 8);
        out.write(0xFF & val);
    }

    public static void write16s(DataOutput out, int val) throws IOException {
        assert (out != null) : "null out";
        assert (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) : "val should be in -32768..32767";
        out.writeShort(val);
    }

    public static void write32u(DataOutput out, long val) throws IOException {
        assert (out != null) : "null out";
        assert (val >= 0L && val <= 0xFFFFFFFFL) : "val should be in 0..4294967295";
        out.writeInt(IntegerUtils.unsignedToSigned(val));
    }

    public static void write32s(DataOutput out, int val) throws IOException {
        assert (out != null) : "null out";
        out.writeInt(val);
    }

    public static void write64s(DataOutput out, long val) throws IOException {
        assert (out != null) : "null out";
        out.writeLong(val);
    }
}

