/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DirectoryContents;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ProcessRunner;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Sys", source="byterun/sys.c")
public final class Sys {
    private static final int[] SYS_OPEN_FLAGS = new int[]{0, 1, 9, 512, 1024, 2048, 0, 0, 4};
    private static final Value WORD_SIZE = Value.createLong(64L);
    private static final double MILLISECS_PER_SEC = 1000.0;
    private static final String SHELL_NAME = "/bin/sh";
    private static final File SHELL_FILE = new File("/bin/sh");

    private Sys() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"According to interpreter parameters, either true", "(JVM shutdown) or false (stop of the interpreted program) exit.", "False exit is needed to allow several interpreted programs", "to coexist within the same JVM", "(as the end of one of these programs should not entail", "exit from JVM and hence stop other programs as well)."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_sys_exit(Value retCode) throws Fail.Exception, FalseExit, Fatal.Exception {
        Context ctxt = CurrentContext.get();
        if (!ctxt.getCodeState().isNative()) {
            Debugger.handleEvent((ByteCodeRunner)OCamlJavaThread.getCodeRunner(), Debugger.EventKind.PROGRAM_EXIT);
        }
        if (ctxt.getParameters().isExitStoppingJVM()) {
            System.exit(retCode.asCastedInt());
            return Value.UNIT;
        }
        ctxt.getThreadsState().getThreadGroup().interrupt();
        ctxt.getThreadsState().interruptAdditionalThreads();
        throw new FalseExit(ctxt, retCode.asCastedInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Pervasives.open_flag list", "int"}, returnType="int")
    public static Value caml_sys_open(Value path, Value flags, Value perm) throws Fail.Exception, FalseExit {
        Context context = CurrentContext.get();
        int flg = Misc.convertFlagList(flags, SYS_OPEN_FLAGS);
        if (context.getFilesState().getFileHook() != null) {
            try {
                MemoryInputStream res;
                InputStream emb = context.getFilesState().getFileHook().getInputStream(context.getFilesState().resourceNameFromPath(path));
                if (emb != null && (res = new RandomAccessInputStream(emb).createInputStream()) != null) {
                    if ((flg & 0x609) != 0) {
                        Sys.sysError(path.asString(), "unable to open embedded file in write mode");
                    }
                    return Value.createLong(context.getFilesState().addChannel(new Channel(res)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        File file = context.getFilesState().getRealFile(path);
        int perms = perm.asCastedInt();
        try {
            CurrentContext.enterBlockingSection();
            Value res = Value.createLong(context.getFilesState().addChannel(new Channel(file, flg, perms)));
            CurrentContext.leaveBlockingSection();
            return res;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(context);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(path.asString(), ioe.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_sys_close(Value fd) throws FalseExit, Fail.Exception {
        try {
            CurrentContext.getFilesState().closeChannel(fd.asCastedInt());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_file_exists(Value name) {
        FilesState fs;
        block7: {
            fs = CurrentContext.getFilesState();
            if (fs.getFileHook() != null) {
                try {
                    InputStream tmp = fs.getInputStreamForPath(name);
                    if (tmp == null) break block7;
                    try {
                        tmp.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return Value.TRUE;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            return fs.getRealFile(name).exists() ? Value.TRUE : Value.FALSE;
        }
        catch (SecurityException se) {
            return Value.FALSE;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_is_directory(Value name) throws Fail.Exception {
        FilesState fs;
        block10: {
            fs = CurrentContext.getFilesState();
            if (fs.getFileHook() != null) {
                try {
                    Value res;
                    InputStream tmp = fs.getInputStreamForPath(name);
                    if (tmp == null) break block10;
                    try {
                        tmp.read();
                        res = Value.FALSE;
                    }
                    catch (Exception e) {
                        res = Value.TRUE;
                    }
                    try {
                        tmp.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return res;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            File dir = fs.getRealFile(name);
            if (!dir.exists()) {
                Sys.sysError(name.asString(), "No such file or directory");
            }
            return dir.isDirectory() ? Value.TRUE : Value.FALSE;
        }
        catch (SecurityException se) {
            return Value.FALSE;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_remove(Value name) throws Fail.Exception {
        try {
            if (!CurrentContext.getFilesState().getRealFile(name).delete()) {
                Sys.sysError(name.asString(), "unable to delete file");
            }
            return Value.UNIT;
        }
        catch (SecurityException se) {
            Sys.sysError(name.asString(), se.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value caml_sys_rename(Value oldName, Value newName) throws Fail.Exception {
        FilesState fs = CurrentContext.getFilesState();
        try {
            if (!fs.getRealFile(oldName).renameTo(fs.getRealFile(newName))) {
                Sys.sysError(null, "unable to rename file");
            }
            return Value.UNIT;
        }
        catch (SecurityException se) {
            Sys.sysError(null, se.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_chdir(Value path) throws Fail.Exception {
        FilesState fs = CurrentContext.getFilesState();
        try {
            File f = fs.getRealFile(path);
            if (f.exists() && f.isDirectory()) {
                fs.setPwd(f);
            } else {
                Sys.sysError(path.asString(), "not a directory");
            }
        }
        catch (SecurityException se) {
            Sys.sysError(path.asString(), se.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_sys_getcwd(Value unit) throws Fail.Exception, FalseExit {
        try {
            return Value.createString(CurrentContext.getFilesState().getPwd().getCanonicalPath());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException | SecurityException e) {
            Sys.sysError(null, e.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value caml_sys_getenv(Value var) throws Fail.Exception {
        String name = var.asString();
        if ("OCAMLJAVA_VERSION".equals(name)) {
            return Value.createString("2.0-early-access9");
        }
        String res = null;
        try {
            res = System.getenv(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (res == null) {
            Fail.raiseNotFound();
        }
        return Value.createString(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[exe_name] is the empty string when the interpreter", "is constructed from a stream that is not a file."}, parameterTypes={"unit"}, returnType="string * string array")
    public static Value caml_sys_get_argv(Value unit) {
        String[] args = CurrentContext.getParameters().getArguments();
        return Value.createBlock(0, Value.createString(CurrentContext.getCodeState().getFile()), args.length > 0 ? Value.createStringArray(args) : CurrentContext.getCodeState().getAtom(0));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_sys_system_command(Value cmd) throws Fail.Exception, FalseExit {
        FilesState fs = CurrentContext.getFilesState();
        String command = cmd.asString();
        String[] tokens = SHELL_FILE.exists() ? new String[]{SHELL_NAME, "-c", command} : (PlatformUtils.isWindowPlatform() ? new String[]{"cmd.exe", "/C", command} : new String[]{command});
        try {
            return Value.createLong(ProcessRunner.execute(fs, tokens, null, true));
        }
        catch (SecurityException se) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(command, se.toString());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(command, ioe.toString());
        }
        catch (IllegalArgumentException iae) {
            Sys.sysError(command, iae.toString());
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns the (real) time elapsed since start, not the", "time used by the program."}, parameterTypes={"unit"}, returnType="float")
    public static Value caml_sys_time(Value unit) {
        long start = CurrentContext.getCodeState().getStart();
        long now = System.currentTimeMillis();
        return Value.createDouble((double)(now - start) / 1000.0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [System.currentTimeMillis() / 1000]."}, parameterTypes={"unit"}, returnType="int array")
    public static Value caml_sys_random_seed(Value unit) {
        int i;
        int[] data = new int[16];
        int n = 0;
        try {
            FileInputStream fis = new FileInputStream("/dev/urandom");
            byte[] bytes = new byte[12];
            int nb = fis.read(bytes);
            for (i = 0; i < nb; ++i) {
                data[n++] = bytes[i];
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        data[n++] = (int)(now % 1000L);
        data[n++] = (int)(now / 1000L);
        Value res = Value.createBlock(0, n);
        for (i = 0; i < n; ++i) {
            res.set(i, Value.createLong(data[i]));
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [''Java''], [''Unix''], [''Cygwin''],", "or [''Win32''] according to interpreter", "parameters. [''Unix''], [''Cygwin''], or [''Win32'']", "needed for [Graphics]. Size is 64."}, parameterTypes={"unit"}, returnType="string * int * bool")
    public static Value caml_sys_get_config(Value unit) {
        String os = CurrentContext.getParameters().getOS();
        if ("auto".equals(os)) {
            os = PlatformUtils.isCygwinPlatform() ? "Cygwin" : (PlatformUtils.isWindowPlatform() ? "Win32" : "Unix");
        }
        return Value.createBlock(0, Value.createString(os), WORD_SIZE, Value.TRUE);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string array")
    public static Value caml_sys_read_directory(Value path) throws Fail.Exception {
        FilesState fs = CurrentContext.getFilesState();
        if (fs.getFileHook() != null) {
            try {
                Value contents = DirectoryContents.getAsValue(fs, path);
                if (contents != null) {
                    return contents;
                }
            }
            catch (Throwable t) {
                Sys.sysError(path.asString(), "Not a directory");
            }
        }
        try {
            String[] f;
            File dir = fs.getRealFile(path);
            if (!dir.exists()) {
                Sys.sysError(path.asString(), "No such file or directory");
            }
            if (!dir.isDirectory()) {
                Sys.sysError(path.asString(), "Not a directory");
            }
            if ((f = dir.list()) == null) {
                Sys.sysError(path.asString(), "Not a directory");
            }
            if (f.length == 0) {
                return CurrentContext.getCodeState().getAtom(0);
            }
            return Value.createStringArray(f);
        }
        catch (SecurityException se) {
            Sys.sysError(path.asString(), se.toString());
            return Value.UNIT;
        }
    }

    public static void sysError(String arg, String ex) throws Fail.Exception {
        if (arg == null) {
            Fail.raiseSysError(ex);
        } else {
            StringBuilder sb = new StringBuilder(arg);
            sb.append(": ");
            sb.append(ex);
            Fail.raiseSysError(sb.toString());
        }
    }

    static void sysIOError(String arg, String ex) throws Fail.Exception {
        Sys.sysError(arg, ex);
    }
}

