/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.primitives.stdlib.Array;
import org.ocamljava.runtime.values.Value;

public final class ArrayFunctions {
    private ArrayFunctions() {
    }

    public static Value init_int(Value len, Value func) throws Fail.Exception, Fatal.Exception, Throwable {
        long size = len.asLong();
        if (size == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        if (size > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value res = Value.createLongBlockFromSize(0, size);
        long raw = 1L;
        int i = 0;
        while ((long)i < size) {
            Value v = NativeApply.apply(func, Value.createFromRawLong(raw));
            res.setRawLong(i, v.getRawValue());
            raw += 2L;
            ++i;
        }
        return res;
    }

    public static Value of_list_int(Value list) {
        if (list.isBlock()) {
            long size = ArrayFunctions.list_length(list);
            Value res = Value.createLongBlockFromSize(0, size);
            long i = 0L;
            Value l = list;
            while (l.isBlock()) {
                res.setRawLong(i++, l.get0().getRawValue());
                l = l.get1();
            }
            return res;
        }
        return CurrentContext.getCodeState().getAtom(0);
    }

    public static long list_length(Value list) {
        long res = 0L;
        Value l = list;
        while (l.isBlock()) {
            l = l.get1();
            ++res;
        }
        return res;
    }

    public static Value map_int(Value func, Value array) throws Fail.Exception, Fatal.Exception, Throwable {
        long size = array.sizeValues();
        if (size == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        Value res = Value.createLongBlockFromSize(0, size);
        int i = 0;
        while ((long)i < size) {
            Value v = NativeApply.apply(func, array.get(i));
            res.setRawLong(i, v.getRawValue());
            ++i;
        }
        return res;
    }

    public static Value mapi_int(Value func, Value array) throws Fail.Exception, Fatal.Exception, Throwable {
        long size = array.sizeValues();
        if (size == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        Value res = Value.createLongBlockFromSize(0, size);
        long raw = 1L;
        int i = 0;
        while ((long)i < size) {
            Value v = NativeApply.apply(func, Value.createFromRawLong(raw), array.get(i));
            res.setRawLong(i, v.getRawValue());
            raw += 2L;
            ++i;
        }
        return res;
    }

    public static Value make_matrix_int(Value sx, Value sy, Value init) throws Fail.Exception {
        long sizeX = sx.asLong();
        if (sizeX == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        Value res = Value.createBlock(0, sizeX);
        int i = 0;
        while ((long)i < sizeX) {
            res.set(i, Array.caml_make_vect_int(sy, init));
            ++i;
        }
        return res;
    }

    public static Value create_matrix_int(Value sx, Value sy, Value init) throws Fail.Exception {
        return ArrayFunctions.make_matrix_int(sx, sy, init);
    }
}

