/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas3D.CanvasParameter;
import com.onemoonscientific.swank.canvas3D.RadiusInterface;
import com.onemoonscientific.swank.canvas3D.RadiusParameter;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import com.sun.j3d.utils.geometry.Cone;
import java.util.Map;
import java.util.TreeMap;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkCone
extends SwkShape
implements RadiusInterface {
    int xDivisions = 15;
    float radius = 1.0f;
    Point3d a = new Point3d(0.0, 0.0, 0.0);
    Point3d b = new Point3d(0.0, 1.0, 0.0);
    static CanvasParameter[] parameters = new CanvasParameter[]{new RadiusParameter()};
    static Map parameterMap = new TreeMap();

    SwkCone(SwkImageCanvas canvas) {
        super(canvas);
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        this.a.x = coords[0];
        this.a.y = coords[1];
        this.a.z = coords[2];
        this.b.x = coords[3];
        this.b.y = coords[4];
        this.b.z = coords[5];
        this.genShape();
    }

    void makeObjectNode() {
        float length = (float)this.a.distance(this.b);
        this.objectNode = new Cone(this.radius, length, 1, this.xDivisions, 1, this.appearance);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = (float)radius;
    }

    public void config(Interp interp, TclObject[] argv, int start) throws TclException {
        if ((argv.length - start) % 2 != 0) {
            throw new TclNumArgsException(interp, 0, argv, "-option value ? -option value? ...");
        }
        boolean doGen = false;
        for (int i = start; i < argv.length; i += 2) {
            if ("-radius".startsWith(argv[i].toString())) {
                this.radius = (float)TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                doGen = true;
            } else if ("-xdivisions".startsWith(argv[i].toString())) {
                this.xDivisions = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                doGen = true;
            } else if (argv[i].toString().startsWith("-tag")) {
                // empty if block
            }
            if (!doGen) continue;
            this.makeObjectNode();
        }
    }

    public TclObject itemGet(Interp interp, TclObject argv) throws TclException {
        return TclString.newInstance((String)"");
    }

    TransformGroup makeTransform() {
        Vector3d base = new Vector3d();
        base.x = this.b.x;
        base.y = this.b.y;
        base.z = this.b.z;
        Vector3d apex = new Vector3d();
        apex.x = this.a.x;
        apex.y = this.a.y;
        apex.z = this.a.z;
        Vector3d center = new Vector3d();
        center.x = (apex.x - base.x) / 2.0 + base.x;
        center.y = (apex.y - base.y) / 2.0 + base.y;
        center.z = (apex.z - base.z) / 2.0 + base.z;
        Vector3d unit = new Vector3d();
        unit.sub((Tuple3d)apex, (Tuple3d)base);
        double height = unit.length();
        unit.normalize();
        Vector3d uX = new Vector3d();
        Vector3d uY = new Vector3d();
        Vector3d uZ = new Vector3d();
        Transform3D rotateFix = new Transform3D();
        uY = new Vector3d(unit);
        uX.cross(unit, new Vector3d(0.0, 0.0, 1.0));
        double magX = uX.length();
        if (magX != 0.0) {
            uX.z /= magX;
            uX.x /= magX;
            uX.y /= magX;
            uZ.cross(uX, uY);
        } else {
            uX = new Vector3d(unit);
            uZ.cross(unit, new Vector3d(0.0, 1.0, 0.0));
            double magZ = uZ.length();
            uZ.x /= magZ;
            uZ.y /= magZ;
            uZ.z /= magZ;
            uY.cross(uZ, uX);
            rotateFix.rotZ(1.5707963267948966);
        }
        Transform3D transMatrix = new Transform3D();
        Transform3D rotateMatrix = new Transform3D(new Matrix4d(uX.x, uX.y, uX.z, 0.0, uY.x, uY.y, uY.z, 0.0, uZ.x, uZ.y, uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
        rotateMatrix.invert();
        transMatrix.mul(rotateMatrix);
        transMatrix.mul(rotateFix);
        transMatrix.setTranslation(center);
        TransformGroup tg = new TransformGroup(transMatrix);
        return tg;
    }

    static {
        SwkCone.initializeParameters(parameters, parameterMap);
    }
}

