/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/isatty.c")
public final class Isatty {
    private Isatty() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Returns [true] if and only if the passed descriptor", "designates standard output or standard error (this", "hack has been set up for camlp4)."}, parameterTypes={"Unix.file_descr"}, returnType="bool")
    public static Value unix_isatty(Value fd) throws Fail.Exception {
        Channel ch = CurrentContext.getFilesState().getChannel(fd.asCastedInt());
        if (ch == null) {
            Unix.fail("iastty", "invalid descriptor");
            return Value.UNIT;
        }
        return ch.isStandardOutputOrError() ? Value.TRUE : Value.FALSE;
    }
}

