/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.SwkDefaultStyledDocument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class SwkDocumentSearch {
    public static final int SEARCH_BACKWARDS = 1;
    public static final int SEARCH_REGEXP = 2;
    public static final int SEARCH_NOCASE = 4;
    public static final int SEARCH_ELIDE = 8;
    private SwkDefaultStyledDocument doc = null;
    Pattern pattern = null;
    String searchString = null;
    int flags = 0;
    int iStart = 0;
    int iEnd = 0;
    int nWrap = 2;
    int startLine = -1;
    int endLine = -1;
    Result result = new Result();

    public SwkDocumentSearch(SwkDefaultStyledDocument searchDoc, String string, int flags) {
        this.doc = searchDoc;
        this.searchString = string;
        this.flags = flags;
    }

    public Result search(int searchStart, int searchEnd) {
        this.result.i = -1;
        this.doc.indexParagraphs();
        this.startLine = this.doc.getParagraph(searchStart);
        this.endLine = this.doc.getParagraph(searchEnd);
        if (this.startLine < 0) {
            return this.result;
        }
        try {
            if ((this.flags & 2) == 2) {
                this.pattern = (this.flags & 4) == 4 ? Pattern.compile(this.searchString, 2) : Pattern.compile(this.searchString);
            }
        }
        catch (PatternSyntaxException psE) {
            this.result.setError("pattern syntax error");
            return this.result;
        }
        this.iStart = this.startLine;
        if ((this.flags & 1) == 1) {
            this.iEnd = 0;
            return this.searchBackwards(searchStart, searchEnd);
        }
        this.iEnd = this.doc.paragraphs.size();
        return this.searchForwards(searchStart, searchEnd);
    }

    public Result searchForwards(int searchStart, int searchEnd) {
        boolean lastLine = false;
        Element elem = null;
        for (int iWrap = 0; iWrap < this.nWrap; ++iWrap) {
            for (int j = this.iStart; j < this.iEnd; ++j) {
                elem = (Element)this.doc.paragraphs.elementAt(j);
                int start = searchStart;
                int elemStart = elem.getStartOffset();
                int elemEnd = elem.getEndOffset();
                if (searchEnd >= elemStart && searchEnd <= elemEnd) {
                    lastLine = true;
                }
                int length = 0;
                if (lastLine) {
                    elemEnd = searchEnd;
                }
                if (this.startLine == this.endLine) {
                    start = searchStart;
                    length = searchEnd - start;
                } else if (iWrap == 0 && j == this.startLine) {
                    start = searchStart;
                    length = elemEnd - start;
                } else if (iWrap == 1 && j == this.startLine) {
                    start = elemStart;
                    length = searchStart - start;
                } else {
                    start = elemStart;
                    length = elemEnd - start - 1;
                }
                if (length < 0) {
                    return this.result;
                }
                String testLine = null;
                try {
                    testLine = this.doc.getText(start, length);
                }
                catch (BadLocationException badLoc) {
                    return this.result;
                }
                int searchIndex = -1;
                int nChars = 0;
                if (this.pattern != null) {
                    Matcher matcher = this.pattern.matcher(testLine);
                    if (matcher.find()) {
                        searchIndex = matcher.start();
                        nChars = matcher.end() - searchIndex;
                    }
                } else {
                    searchIndex = testLine.indexOf(this.searchString);
                    nChars = this.searchString.length();
                }
                if (searchIndex >= 0) {
                    this.result.i = nChars;
                    this.result.s = j + 1 + "." + (start - elemStart + searchIndex);
                    return this.result;
                }
                if (!lastLine) continue;
                return this.result;
            }
            this.iStart = 0;
            this.iEnd = this.startLine;
        }
        return this.result;
    }

    public Result searchBackwards(int searchStart, int searchEnd) {
        Element elem = null;
        boolean lastLine = false;
        for (int iWrap = 0; iWrap < this.nWrap; ++iWrap) {
            for (int j = this.iStart; j >= this.iEnd; --j) {
                elem = (Element)this.doc.paragraphs.elementAt(j);
                int start = searchStart;
                int elemStart = elem.getStartOffset();
                int elemEnd = elem.getEndOffset();
                if (searchEnd >= elemStart && searchEnd <= elemEnd) {
                    lastLine = true;
                }
                int length = 0;
                if (lastLine) {
                    elemEnd = searchEnd;
                }
                if (this.startLine == this.endLine) {
                    start = searchEnd;
                    length = searchStart - start;
                } else if (iWrap == 0 && j == this.startLine) {
                    start = elemStart;
                    length = searchStart - start;
                } else if (iWrap == 1 && j == this.startLine) {
                    start = searchStart + 1;
                    length = elemEnd - start;
                } else {
                    start = elemStart;
                    length = elemEnd - start;
                }
                if (length < 0) {
                    return this.result;
                }
                String testLine = null;
                try {
                    testLine = this.doc.getText(start, length);
                }
                catch (BadLocationException badLoc) {
                    return this.result;
                }
                int searchIndex = -1;
                int nChars = 0;
                if (this.pattern != null) {
                    Matcher matcher = this.pattern.matcher(testLine);
                    while (matcher.find()) {
                        searchIndex = matcher.start();
                        nChars = matcher.end() - searchIndex;
                    }
                } else {
                    searchIndex = testLine.lastIndexOf(this.searchString);
                    nChars = this.searchString.length();
                }
                if (searchIndex >= 0) {
                    this.result.i = nChars;
                    this.result.s = j + 1 + "." + (start - elemStart + searchIndex);
                    return this.result;
                }
                if (!lastLine) continue;
                return this.result;
            }
            this.iStart = this.doc.paragraphs.size() - 1;
            this.iEnd = this.startLine;
        }
        return this.result;
    }
}

