/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Iterator;
import java.util.TreeMap;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class TclIndex
implements InternalRep {
    private int index;
    private String[] table;
    TreeMap TM;

    private TclIndex(int i, String[] tab) {
        this.index = i;
        this.table = tab;
    }

    private TclIndex(int i, TreeMap TM) {
        this.index = i;
    }

    public InternalRep duplicate() {
        return new TclIndex(this.index, this.table);
    }

    public void dispose() {
    }

    public String toString() {
        return this.table[this.index];
    }

    public static int get(Interp interp, TclObject tobj, String[] table, String msg, int flags) throws TclException {
        int index;
        block10: {
            InternalRep rep = tobj.getInternalRep();
            if (rep instanceof TclIndex && ((TclIndex)rep).table == table) {
                return ((TclIndex)rep).index;
            }
            String str = tobj.toString();
            int strLen = str.length();
            int tableLen = table.length;
            index = -1;
            int numAbbrev = 0;
            if (strLen > 0) {
                for (int i = 0; i < tableLen; ++i) {
                    String option = table[i];
                    if ((flags & 1) == 1 && option.length() != strLen) continue;
                    if (option.equals(str)) {
                        index = i;
                        break block10;
                    }
                    if (!option.startsWith(str)) continue;
                    ++numAbbrev;
                    index = i;
                }
            }
            if (numAbbrev != 1) {
                StringBuffer sbuf = new StringBuffer();
                if (numAbbrev > 1) {
                    sbuf.append("ambiguous ");
                } else {
                    sbuf.append("bad ");
                }
                sbuf.append(msg);
                sbuf.append(" \"");
                sbuf.append(str);
                sbuf.append("\"");
                sbuf.append(": must be ");
                sbuf.append(table[0]);
                for (int i = 1; i < tableLen; ++i) {
                    if (i == tableLen - 1) {
                        sbuf.append(i > 1 ? ", or " : " or ");
                    } else {
                        sbuf.append(", ");
                    }
                    sbuf.append(table[i]);
                }
                throw new TclException(interp, sbuf.toString());
            }
        }
        tobj.setInternalRep((InternalRep)new TclIndex(index, table));
        return index;
    }

    public static int get(Interp interp, TclObject tobj, TreeMap TM, String msg, int flags) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof TclIndex && ((TclIndex)rep).TM == TM) {
            return ((TclIndex)rep).index;
        }
        String str = tobj.toString();
        int strLen = str.length();
        int tableLen = TM.size();
        int index = -1;
        int numAbbrev = 0;
        Integer IObj = (Integer)TM.get(str);
        if (IObj != null) {
            index = IObj;
        } else if ((flags & 1) != 1) {
            for (Object obj : TM.keySet()) {
                String option = (String)obj;
                if (option.startsWith(str)) {
                    ++numAbbrev;
                    index = (Integer)TM.get(option);
                }
                if (option.compareTo(str) <= 0) continue;
                break;
            }
        } else if (numAbbrev != 1) {
            StringBuffer sbuf = new StringBuffer();
            if (numAbbrev > 1) {
                sbuf.append("ambiguous ");
            } else {
                sbuf.append("bad ");
            }
            sbuf.append(msg);
            sbuf.append(" \"");
            sbuf.append(str);
            sbuf.append("\"");
            sbuf.append(": must be ");
            Iterator it = TM.keySet().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                String option = (String)obj;
                sbuf.append(option);
                if (!it.hasNext()) continue;
                sbuf.append(", ");
            }
            throw new TclException(interp, sbuf.toString());
        }
        tobj.setInternalRep((InternalRep)new TclIndex(index, TM));
        return index;
    }

    void testUpdateIndex(int index) {
        this.index = index;
    }
}

