/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.SelectionCmd;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkDocumentSearch;
import com.onemoonscientific.swank.SwkJTextPane;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJTextPaneWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "elem", "insert", "tag", "celem", "index", "delete", "mark", "compare", "get", "see", "window", "bbox", "search", "debug"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ELEM = 2;
    private static final int OPT_INSERT = 3;
    private static final int OPT_TAG = 4;
    private static final int OPT_CELEM = 5;
    private static final int OPT_INDEX = 6;
    private static final int OPT_DELETE = 7;
    private static final int OPT_MARK = 8;
    private static final int OPT_COMPARE = 9;
    private static final int OPT_GET = 10;
    private static final int OPT_SEE = 11;
    private static final int OPT_WINDOW = 12;
    private static final int OPT_BBOX = 13;
    private static final int OPT_SEARCH = 14;
    private static final int OPT_DEBUG = 15;
    static boolean gotDefaults = false;
    Interp interp = null;

    SwkJTextPaneWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean i = false;
        this.interp = interp;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJTextPane swkjtextpane = (SwkJTextPane)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjtextpane.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjtextpane.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjtextpane.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjtextpane.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJTextPane.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjtextpane.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.elem(interp, swkjtextpane, argv);
                break;
            }
            case 5: {
                this.celem(interp, swkjtextpane, argv);
                break;
            }
            case 6: {
                this.index(interp, swkjtextpane, argv);
                break;
            }
            case 3: {
                this.insert(interp, swkjtextpane, argv);
                break;
            }
            case 7: {
                this.delete(interp, swkjtextpane, argv);
                break;
            }
            case 4: {
                this.tag(interp, swkjtextpane, argv);
                break;
            }
            case 8: {
                this.mark(interp, swkjtextpane, argv);
                break;
            }
            case 9: {
                this.compare(interp, swkjtextpane, argv);
                break;
            }
            case 15: {
                this.debug(interp, swkjtextpane, argv);
                break;
            }
            case 14: {
                this.search(interp, swkjtextpane, argv);
                break;
            }
            case 11: {
                this.see(interp, swkjtextpane, argv);
                break;
            }
            case 13: {
                this.bbox(interp, swkjtextpane, argv);
                break;
            }
            case 12: {
                this.window(interp, swkjtextpane, argv);
                break;
            }
            case 10: {
                this.get(interp, swkjtextpane, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void elem(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        Element elem;
        ElementIterator elIter = new ElementIterator(swkjtextpane.doc);
        while ((elem = elIter.next()) != null) {
            String string;
            AttributeSet attrs;
            Element elem2 = swkjtextpane.doc.getCharacterElement(elem.getStartOffset());
            if (elem2 != null && (attrs = elem2.getAttributes()) != null) {
                string = (String)attrs.getAttribute("tagName");
            }
            if ((elem2 = swkjtextpane.doc.getParagraphElement(elem.getStartOffset())) == null || (attrs = elem2.getAttributes()) == null) continue;
            string = (String)attrs.getAttribute("tagName");
        }
    }

    void celem(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        Element elem = swkjtextpane.doc.getCharacterElement(TclInteger.get((Interp)interp, (TclObject)argv[2]));
        if (elem != null) {
            interp.setResult(elem.getName() + " " + elem.getElementCount() + " " + elem.getStartOffset() + " " + elem.getEndOffset());
        }
    }

    void index(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        String index = new Index().exec(swkjtextpane, argv[2].toString());
        interp.setResult(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void tag(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        if (argv[2].toString().equals("configure")) {
            if (argv.length < 4) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            if (argv.length < 6) {
                Style style = new StyleGet().exec(swkjtextpane, argv[3].toString(), false);
                if (style == null) {
                    throw new TclException(interp, "coudn't find style " + argv[3].toString());
                }
                if (argv.length > 4) {
                    swkjtextpane.getStyleStuff(interp, style, argv[4], true);
                    return;
                } else {
                    swkjtextpane.getStyleStuff(interp, style, null, true);
                }
                return;
            } else {
                Style style = new StyleGet().exec(swkjtextpane, argv[3].toString(), true);
                SwkJTextPane.setStyleStuff(interp, style, argv, 4);
                new StyleSet().exec(swkjtextpane, style);
            }
            return;
        } else if (argv[2].toString().equals("cget")) {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            Style style = swkjtextpane.getStyle(argv[3].toString());
            if (style == null) throw new TclException(interp, "coudn't find style " + argv[3].toString());
            swkjtextpane.getStyleStuff(interp, style, argv[4], false);
            return;
        } else if (argv[2].toString().equals("add")) {
            if (argv.length < 5) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            String arg5 = null;
            if (argv.length == 6) {
                arg5 = argv[5].toString();
            }
            new Add().exec(swkjtextpane, argv[0].toString(), argv[3].toString(), argv[4].toString(), arg5);
            return;
        } else if (argv[2].toString().equals("bind")) {
            SwkBinding binding;
            if (argv.length < 4) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            Style style = new StyleGet().exec(swkjtextpane, argv[3].toString(), false);
            if (style == null) {
                throw new TclException(interp, "style " + argv[3].toString() + " doesn't exist");
            }
            if (argv.length <= 4 || (binding = SwkBind.getBinding(interp, argv, 4)) == null) return;
            swkjtextpane.setupBinding(interp, binding, argv[3].toString());
            SwkBind.updateBindingCommand(interp, binding, argv, 4);
            return;
        } else if (argv[2].toString().equals("names")) {
            ArrayList arrayResult;
            String arg1 = null;
            if (argv.length > 3) {
                arg1 = argv[3].toString();
            }
            if ((arrayResult = new TagGet().names(swkjtextpane, arg1)) == null) return;
            if (arg1 != null) {
                interp.setResult((String)arrayResult.get(0));
                return;
            } else {
                TclObject list = TclList.newInstance();
                for (int i = 0; i < arrayResult.size(); ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)arrayResult.get(i))));
                }
                interp.setResult(list);
            }
            return;
        } else if (argv[2].toString().equals("ranges")) {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ... ?");
            }
            String ranges = new TagGet().ranges(swkjtextpane, argv[3].toString());
            interp.setResult(ranges);
            return;
        } else if (argv[2].toString().equals("delete")) {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            new StyleRemove().removeStyle(swkjtextpane, argv[3].toString());
            return;
        } else {
            if (!argv[2].toString().equals("remove")) return;
            if (argv.length != 6) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            new StyleRemove().removeStyleFromRange(swkjtextpane, argv[3].toString(), argv[4].toString(), argv[5].toString());
        }
    }

    void mark(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        if (argv[2].toString().equals("set")) {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            new MarkSet().exec(swkjtextpane, argv[3].toString(), argv[4].toString());
        } else if (argv[2].toString().equals("gravity")) {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            new MarkSet().execGravity(swkjtextpane, argv[3].toString(), argv[4].toString());
        } else if (argv[2].toString().equals("unset")) {
            String[] marks = new String[argv.length - 3];
            for (int i = 3; i < argv.length; ++i) {
                marks[i - 3] = argv[i].toString();
            }
            new MarkSet().execUnMark(swkjtextpane, marks);
        } else if (argv[2].toString().equals("names")) {
            ArrayList arrayResult = new MarkGet().exec(swkjtextpane);
            TclObject list = TclList.newInstance();
            if (arrayResult != null) {
                for (int i = 0; i < arrayResult.size(); ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)arrayResult.get(i))));
                }
            }
            interp.setResult(list);
        }
    }

    void debug(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 2 && argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "boolean");
        }
        if (argv.length == 3) {
            swkjtextpane.debug = TclBoolean.get((Interp)interp, (TclObject)argv[2]);
        }
        interp.setResult(swkjtextpane.debug);
    }

    void compare(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "index1 op index2");
        }
        Result result = new Compare().exec(swkjtextpane, argv[2].toString(), argv[3].toString(), argv[4].toString());
        result.checkError(interp);
        interp.setResult(result.b);
    }

    void search(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
        }
        int searchFlags = 0;
        boolean forwardsMode = true;
        boolean exactMode = true;
        boolean regexpMode = true;
        boolean flagSearch = true;
        String countVar = null;
        int patternIndex = -1;
        int startIndex = -1;
        int endIndex = -1;
        int index2 = -1;
        for (int i = 2; i < argv.length; ++i) {
            if (argv[i].toString().charAt(0) != '-' || !flagSearch) {
                if (patternIndex == -1) {
                    patternIndex = i;
                    continue;
                }
                if (startIndex == -1) {
                    startIndex = i;
                    continue;
                }
                if (endIndex == -1) {
                    endIndex = i;
                    continue;
                }
                throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
            }
            if (patternIndex != -1) {
                throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
            }
            if ("--".equals(argv[i].toString())) {
                flagSearch = false;
                continue;
            }
            if ("-forwards".startsWith(argv[i].toString()) || "-exact".startsWith(argv[i].toString())) continue;
            if ("-backwards".startsWith(argv[i].toString())) {
                searchFlags |= 1;
                continue;
            }
            if ("-regexp".startsWith(argv[i].toString())) {
                searchFlags |= 2;
                continue;
            }
            if ("-nocase".startsWith(argv[i].toString())) {
                searchFlags |= 4;
                continue;
            }
            if ("-elide".startsWith(argv[i].toString())) {
                searchFlags |= 8;
                continue;
            }
            if ("-count".startsWith(argv[i].toString())) {
                if (++i >= argv.length) {
                    throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
                }
                countVar = argv[i].toString();
                continue;
            }
            throw new TclException(interp, "bad switch \"" + argv[i].toString() + "\": must be --, -backward, -count, -elide, -exact, -forward, -nocase, or -regexp");
        }
        if (patternIndex == -1) {
            throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
        }
        if (startIndex == -1) {
            throw new TclNumArgsException(interp, 2, argv, "?switches? pattern index ?stopIndex?");
        }
        String index1Arg = argv[startIndex].toString();
        String index2Arg = null;
        if (endIndex != -1) {
            index2Arg = argv[endIndex].toString();
        }
        String patternString = argv[patternIndex].toString();
        Result result = new Search().exec(swkjtextpane, patternString, index1Arg, index2Arg, searchFlags);
        result.checkError(interp);
        if (countVar != null && result.i >= 0) {
            TclObject tObj = TclInteger.newInstance((int)result.i);
            interp.setVar(countVar, tObj, 0);
        }
        interp.setResult(result.s);
    }

    void get(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "index1 ?index2?");
        }
        String index1Arg = argv[2].toString();
        String index2Arg = null;
        if (argv.length == 4) {
            index2Arg = argv[3].toString();
        }
        Result result = new Get().exec(swkjtextpane, index1Arg, index2Arg);
        result.checkError(interp);
        interp.setResult(result.s);
    }

    void insert(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 2, argv, "index chars ?tagList chars tagList ...?");
        }
        int nPairs = (argv.length - 2) / 2;
        int k = 0;
        String[] groupedStyleStrings = new String[nPairs];
        String[][] tagStrings = new String[nPairs][];
        String[] insertStrings = new String[nPairs];
        for (int i = 3; i < argv.length; i += 2) {
            if (i + 1 < argv.length) {
                TclObject[] tags = TclList.getElements((Interp)interp, (TclObject)argv[i + 1]);
                groupedStyleStrings[k] = argv[i + 1].toString();
                tagStrings[k] = new String[tags.length];
                for (int j = 0; j < tags.length; ++j) {
                    tagStrings[k][j] = tags[j].toString();
                }
            }
            insertStrings[k] = argv[i].toString();
            ++k;
        }
        new Insert().exec(swkjtextpane, argv[2].toString(), groupedStyleStrings, tagStrings, insertStrings);
    }

    void delete(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "index1 ?index2?");
        }
        String firstArg = argv[2].toString();
        String endArg = null;
        if (argv.length > 3) {
            endArg = argv[3].toString();
        }
        new Delete().exec(swkjtextpane, firstArg, endArg);
    }

    void see(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        String indexArg = argv[2].toString();
        new See().exec(swkjtextpane, indexArg);
    }

    void bbox(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        String indexArg = argv[2].toString();
        Rectangle rect = new BBox().exec(swkjtextpane, indexArg);
        if (rect == null) {
            throw new TclException(interp, "bad location in bbox");
        }
        interp.setResult(SwankUtil.parseRectangle(rect));
    }

    void window(Interp interp, SwkJTextPane swkjtextpane, TclObject[] argv) throws TclException {
        if (argv.length < 6) {
            throw new TclNumArgsException(interp, 1, argv, "create ?arg arg ...?");
        }
        if ("create".startsWith(argv[2].toString())) {
            Object windowObject = null;
            String windowName = null;
            for (int i = 4; i < argv.length; ++i) {
                if (!"-window".startsWith(argv[i].toString())) continue;
                if (++i == argv.length) {
                    throw new TclException(interp, "value for \"-window\" missing");
                }
                windowName = argv[i].toString();
                windowObject = Widgets.get(interp, windowName);
                if (windowObject != null && windowObject instanceof Component) continue;
                throw new TclException(interp, "bad window path name \"" + windowName + "\"");
            }
            String indexArg = argv[3].toString();
            new Window().exec(swkjtextpane, indexArg, windowName, windowObject);
        }
    }

    class Window
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String indexArg = null;
        String windowName = null;
        Object windowObject = null;

        Window() {
        }

        void exec(SwkJTextPane swkjtextpane, String indexArg, String windowName, Object windowObject) {
            this.swkjtextpane = swkjtextpane;
            this.indexArg = indexArg;
            this.windowObject = windowObject;
            this.windowName = windowName;
            this.execOnThread();
        }

        public void run() {
            int index1 = 0;
            try {
                index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.indexArg);
                this.swkjtextpane.doc.setMark(this.swkjtextpane, this.windowName, this.indexArg);
            }
            catch (Exception e) {
                System.out.println("caught " + e.getMessage());
                return;
            }
            int endOffset = this.swkjtextpane.doc.getEndPosition().getOffset();
            if (index1 >= endOffset) {
                index1 = endOffset - 1;
            }
            this.swkjtextpane.setCaretPosition(index1);
            this.swkjtextpane.insertComponent((Component)this.windowObject);
        }
    }

    class BBox
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String indexArg = null;
        Rectangle rect = null;

        BBox() {
        }

        Rectangle exec(SwkJTextPane swkjtextpane, String indexArg) {
            this.swkjtextpane = swkjtextpane;
            this.indexArg = indexArg;
            this.execOnThread();
            return this.rect;
        }

        public void run() {
            int index1 = 0;
            try {
                index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.indexArg);
            }
            catch (Exception e) {
                System.out.println("caught " + e.getMessage());
                return;
            }
            int endOffset = this.swkjtextpane.doc.getEndPosition().getOffset();
            if (index1 >= endOffset) {
                index1 = endOffset - 1;
            }
            try {
                this.rect = this.swkjtextpane.modelToView(index1);
            }
            catch (BadLocationException badLoc) {
                SwkJTextPaneWidgetCmd.this.interp.backgroundError();
                return;
            }
        }
    }

    class See
    extends UpdateOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String indexArg = null;

        See() {
        }

        void exec(SwkJTextPane swkjtextpane, String indexArg) {
            this.swkjtextpane = swkjtextpane;
            this.indexArg = indexArg;
            this.execOnThread();
        }

        public void run() {
            int index1 = 0;
            try {
                index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.indexArg);
            }
            catch (Exception e) {
                System.out.println("caught " + e.getMessage());
                return;
            }
            int endOffset = this.swkjtextpane.doc.getEndPosition().getOffset();
            if (index1 >= endOffset) {
                index1 = endOffset - 1;
            }
            try {
                Rectangle view = this.swkjtextpane.modelToView(index1);
                if (view != null) {
                    this.swkjtextpane.scrollRectToVisible(view);
                }
            }
            catch (BadLocationException badLoc) {
                SwkJTextPaneWidgetCmd.this.interp.backgroundError();
                return;
            }
        }
    }

    class Delete
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String firstArg = null;
        String endArg = null;

        Delete() {
        }

        void exec(SwkJTextPane swkjtextpane, String firstArg, String endArg) {
            this.swkjtextpane = swkjtextpane;
            this.firstArg = firstArg;
            this.endArg = endArg;
            this.execOnThread();
        }

        public void run() {
            int index1 = 0;
            try {
                index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.firstArg);
            }
            catch (Exception e) {
                System.out.println("caught " + e.getMessage());
                return;
            }
            int index2 = index1 + 1;
            int endOffset = this.swkjtextpane.doc.getEndPosition().getOffset();
            if (this.endArg != null) {
                try {
                    index2 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.endArg);
                }
                catch (Exception e) {
                    System.out.println("caught " + e);
                    return;
                }
                if (index2 >= endOffset - 1) {
                    index2 = endOffset - 1;
                }
                if (index2 == 0) {
                    return;
                }
            }
            if (index2 < index1) {
                return;
            }
            if (index2 >= endOffset) {
                return;
            }
            if (!this.swkjtextpane.isEditable()) {
                return;
            }
            try {
                this.swkjtextpane.doc.remove(index1, index2 - index1);
            }
            catch (BadLocationException badLoc) {
                System.out.println("badLoc");
            }
        }
    }

    class Insert
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String indexArg = null;
        String[] groupedStyleStrings = null;
        String[][] tagStrings = null;
        String[] insertStrings = null;

        Insert() {
        }

        void exec(SwkJTextPane swkjtextpane, String indexArg, String[] groupedStyleStrings, String[][] tagStrings, String[] insertStrings) {
            this.swkjtextpane = swkjtextpane;
            this.indexArg = indexArg;
            this.groupedStyleStrings = groupedStyleStrings;
            this.tagStrings = tagStrings;
            this.insertStrings = insertStrings;
            this.execOnThread();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int index = 0;
            try {
                index = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.indexArg);
            }
            catch (Exception e) {
                System.out.println("caught " + e);
                return;
            }
            int endOffset = this.swkjtextpane.doc.getEndPosition().getOffset();
            if (index >= endOffset) {
                index = endOffset - 1;
            }
            Style style = null;
            Style firstStyle = null;
            Style groupedStyle = null;
            Object tags = null;
            if (!this.swkjtextpane.isEditable()) {
                return;
            }
            int i = 0;
            while (i < this.groupedStyleStrings.length) {
                if (this.groupedStyleStrings[i] != null && (groupedStyle = this.swkjtextpane.getStyle(this.groupedStyleStrings[i])) == null) {
                    groupedStyle = this.swkjtextpane.addStyle(this.groupedStyleStrings[i], null);
                    this.swkjtextpane.initStyle(groupedStyle);
                    for (int j = 0; j < this.tagStrings[i].length; ++j) {
                        style = this.swkjtextpane.getStyle(this.tagStrings[i][j]);
                        if (style == null) {
                            style = this.swkjtextpane.addStyle(this.tagStrings[i][j], null);
                            style.addAttribute("tagName", this.tagStrings[i][j]);
                        } else {
                            groupedStyle.addAttributes(style);
                        }
                        if (j != 0) continue;
                        firstStyle = style;
                    }
                    groupedStyle.addAttribute("tagName", this.groupedStyleStrings[i]);
                }
                try {
                    String tagNames;
                    if (groupedStyle == null) {
                        this.swkjtextpane.doc.insertString(index, this.insertStrings[i], this.swkjtextpane.defaultStyle);
                    } else {
                        this.swkjtextpane.doc.insertString(index, this.insertStrings[i], groupedStyle);
                    }
                    int index2 = this.insertStrings[i].length() + index;
                    if (this.tagStrings[i] != null) {
                        for (int j = 1; j < this.tagStrings[i].length; ++j) {
                            style = this.swkjtextpane.getStyle(this.tagStrings[i][j]);
                            if (style == null) continue;
                        }
                    }
                    if (groupedStyle == null ? (tagNames = (String)this.swkjtextpane.defaultStyle.getAttribute("tagName")) == null : (tagNames = (String)groupedStyle.getAttribute("tagName")) == null) {
                        // empty if block
                    }
                }
                catch (BadLocationException badLoc) {
                }
                catch (NullPointerException nullE) {
                    // empty catch block
                }
                index += this.insertStrings[i].length();
                ++i;
            }
            return;
        }
    }

    class Get
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String index1Arg = null;
        String index2Arg = null;
        Result result = new Result();

        Get() {
        }

        Result exec(SwkJTextPane swkjtextpane, String index1Arg, String index2Arg) {
            this.swkjtextpane = swkjtextpane;
            this.index1Arg = index1Arg;
            this.index2Arg = index2Arg;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            int index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.index1Arg);
            int index2 = index1 + 1;
            if (this.index2Arg != null) {
                index2 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.index2Arg);
                if (this.index2Arg.equals("end") && index2 == 0) {
                    return;
                }
            }
            if (index2 >= index1) {
                try {
                    this.result.s = this.swkjtextpane.doc.getText(index1, index2 - index1);
                }
                catch (BadLocationException badLoc) {
                    this.result.setError(badLoc.toString());
                }
            }
        }
    }

    class Search
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String patternString = null;
        String index1Arg = null;
        String index2Arg = null;
        int searchFlags = 0;
        Result result = null;

        Search() {
        }

        Result exec(SwkJTextPane swkjtextpane, String patternString, String index1Arg, String index2Arg, int searchFlags) {
            this.swkjtextpane = swkjtextpane;
            this.patternString = patternString;
            this.index1Arg = index1Arg;
            this.index2Arg = index2Arg;
            this.searchFlags = searchFlags;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            int index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.index1Arg);
            int index2 = index1 + 1;
            if (this.index2Arg != null) {
                if (this.index2Arg.equals("end") && index2 == 0) {
                    return;
                }
                index2 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.index2Arg);
            }
            SwkDocumentSearch docSearch = new SwkDocumentSearch(this.swkjtextpane.doc, this.patternString, this.searchFlags);
            this.result = docSearch.search(index1, index2);
        }
    }

    class Compare
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String arg1 = "";
        String op = "";
        String arg2 = "";
        Result result = null;

        Compare() {
        }

        Result exec(SwkJTextPane swkjtextpane, String arg1, String op, String arg2) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.op = op;
            this.arg2 = arg2;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = this.swkjtextpane.doc.compareIndices(this.swkjtextpane, this.arg1, this.op, this.arg2);
        }
    }

    class MarkGet
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        ArrayList result = null;

        MarkGet() {
        }

        ArrayList exec(SwkJTextPane swkjtextpane) {
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = this.swkjtextpane.doc.getMarks();
        }
    }

    class MarkSet
    extends UpdateOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String arg1 = null;
        String arg2 = null;
        String[] marks = null;
        int mode = 0;

        MarkSet() {
        }

        void exec(SwkJTextPane swkjtextpane, String arg1, String arg2) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.execOnThread();
        }

        void execGravity(SwkJTextPane swkjtextpane, String arg1, String arg2) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.mode = 1;
            this.execOnThread();
        }

        void execUnMark(SwkJTextPane swkjtextpane, String[] marks) {
            this.swkjtextpane = swkjtextpane;
            this.marks = marks;
            this.mode = 2;
            this.execOnThread();
        }

        public void run() {
            if (this.mode == 0) {
                this.swkjtextpane.doc.setMark(this.swkjtextpane, this.arg1, this.arg2);
            } else if (this.mode == 1) {
                this.swkjtextpane.doc.setMarkGravity(this.swkjtextpane, this.arg1, this.arg2);
            } else {
                this.swkjtextpane.doc.unsetMarks(this.marks);
            }
        }
    }

    class TagGet
    extends GetValueOnEventThread {
        static final int RANGES = 0;
        static final int NAMES = 1;
        SwkJTextPane swkjtextpane = null;
        String arg1 = null;
        String result = null;
        ArrayList resultList = null;
        int mode = 0;

        TagGet() {
        }

        String ranges(SwkJTextPane swkjtextpane, String arg1) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.mode = 0;
            this.execOnThread();
            return this.result;
        }

        ArrayList names(SwkJTextPane swkjtextpane, String arg1) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.mode = 1;
            this.execOnThread();
            return this.resultList;
        }

        public void run() {
            switch (this.mode) {
                case 0: {
                    this.runRanges();
                    break;
                }
                case 1: {
                    this.runNames();
                    break;
                }
            }
        }

        public void runRanges() {
            this.result = this.swkjtextpane.doc.getRanges(this.arg1, 0);
        }

        public void runNames() {
            if (this.arg1 == null) {
                this.resultList = this.swkjtextpane.doc.getTags();
            } else {
                AttributeSet attrs;
                int index = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.arg1);
                Element elem = this.swkjtextpane.doc.getCharacterElement(index);
                if (elem != null && (attrs = elem.getAttributes()) != null) {
                    String tag = (String)attrs.getAttribute("tagName");
                    this.resultList = new ArrayList();
                    this.resultList.add(tag);
                }
            }
        }
    }

    class StyleGet
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String arg1 = null;
        Style style = null;
        boolean addIf = false;

        StyleGet() {
        }

        Style exec(SwkJTextPane swkjtextpane, String arg1, boolean addIf) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.addIf = addIf;
            this.execOnThread();
            return this.style;
        }

        public void run() {
            this.style = this.swkjtextpane.getStyle(this.arg1);
            if (this.style == null && this.addIf) {
                this.style = this.swkjtextpane.addStyle(this.arg1, null);
                this.style.addAttribute("tagName", this.arg1);
            }
        }
    }

    class StyleSet
    extends UpdateOnEventThread {
        SwkJTextPane swkjtextpane = null;
        Style style = null;

        StyleSet() {
        }

        void exec(SwkJTextPane swkjtextpane, Style style) {
            this.swkjtextpane = swkjtextpane;
            this.style = style;
            this.execOnThread();
        }

        public void run() {
            this.swkjtextpane.doc.styleUpdated(this.swkjtextpane, this.style, false);
        }
    }

    class StyleRemove
    extends UpdateOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String arg1 = null;
        String arg2 = null;
        String arg3 = null;
        String[] marks = null;
        int mode = 0;

        StyleRemove() {
        }

        void removeStyle(SwkJTextPane swkjtextpane, String arg1) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.mode = 0;
            this.execOnThread();
        }

        void removeStyleFromRange(SwkJTextPane swkjtextpane, String arg1, String arg2, String arg3) {
            this.swkjtextpane = swkjtextpane;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.mode = 1;
            this.execOnThread();
        }

        public void run() {
            if (this.mode == 0) {
                this.swkjtextpane.doc.removeStyle(this.swkjtextpane, this.arg1);
            } else {
                int index1 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.arg2);
                int index2 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.arg3);
                this.swkjtextpane.doc.removeStyleFromRange(this.swkjtextpane, index1, index2, this.arg1);
            }
        }
    }

    class Add
    extends UpdateOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String arg0 = null;
        String arg1 = null;
        String arg2 = null;
        String arg3 = null;

        Add() {
        }

        void exec(SwkJTextPane swkjtextpane, String arg0, String arg1, String arg2, String arg3) {
            this.swkjtextpane = swkjtextpane;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.execOnThread();
        }

        public void run() {
            Style style = this.swkjtextpane.getStyle(this.arg1);
            int index = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.arg2);
            int index2 = index + 1;
            if (this.arg3 != null) {
                index2 = this.swkjtextpane.doc.getIndexLC(this.swkjtextpane, this.arg3);
            }
            if (this.arg1.equals("sel")) {
                this.swkjtextpane.setCaretPosition(index);
                this.swkjtextpane.moveCaretPosition(index2);
                if (!this.swkjtextpane.selectionWindowAdded) {
                    SelectionCmd.addSelectionWindow(this.arg0);
                    this.swkjtextpane.selectionWindowAdded = true;
                }
            }
            if (style == null) {
                style = this.swkjtextpane.addStyle(this.arg1, null);
                style.addAttribute("tagName", this.arg1);
            }
            this.swkjtextpane.doc.addStyleToRange(this.swkjtextpane, index, index2, this.arg1);
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkJTextPane swkjtextpane = null;
        String indexArg = null;
        String index = "";

        Index() {
        }

        String exec(SwkJTextPane swkjtextpane, String indexArg) {
            this.swkjtextpane = swkjtextpane;
            this.indexArg = indexArg;
            this.execOnThread();
            return this.index;
        }

        public void run() {
            this.index = this.swkjtextpane.doc.getIndex(this.swkjtextpane, this.indexArg);
        }
    }
}

