/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJTree;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJTreeWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "path", "node", "update"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_PATH = 2;
    private static final int OPT_NODE = 3;
    private static final int OPT_UPDATE = 4;
    static boolean gotDefaults = false;

    SwkJTreeWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        final SwkJTree swkjtree = (SwkJTree)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjtree.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjtree.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjtree.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjtree.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJTree.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjtree.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.getPath(interp, swkjtree, argv);
                break;
            }
            case 3: {
                this.node(interp, swkjtree, argv);
                break;
            }
            case 4: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DefaultTreeModel model = (DefaultTreeModel)swkjtree.getModel();
                        model.reload();
                    }
                });
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void node(Interp interp, SwkJTree swkjtree, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv[2].toString().equals("add")) {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            interp.resetResult();
            int[] iNodes = null;
            if (!argv[3].toString().equals("root")) {
                TclObject[] nodeList = TclList.getElements((Interp)interp, (TclObject)argv[3]);
                iNodes = new int[nodeList.length];
                for (int i = 0; i < iNodes.length; ++i) {
                    iNodes[i] = TclInteger.get((Interp)interp, (TclObject)nodeList[i]);
                }
            }
            String value = argv[4].toString();
            new NodeAdd().add(swkjtree, iNodes, value);
        } else if (argv[2].toString().equals("count")) {
            TreePath treePath = new Path().exec(swkjtree);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (node == null) {
                interp.resetResult();
            } else {
                interp.setResult(node.getChildCount());
            }
        }
    }

    void getPath(Interp interp, SwkJTree swkjtree, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv[2].toString().equals("get")) {
            interp.resetResult();
            TreePath treePath = new Path().exec(swkjtree);
            TclObject list = TclList.newInstance();
            if (treePath != null) {
                for (int iPath = 0; iPath < treePath.getPathCount(); ++iPath) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)treePath.getPathComponent(iPath).toString()));
                }
            }
            interp.setResult(list);
        }
    }

    class Path
    extends GetValueOnEventThread {
        SwkJTree swkjtree;
        TreePath treePath = null;

        Path() {
        }

        TreePath exec(SwkJTree swkjtree) {
            this.swkjtree = swkjtree;
            this.execOnThread();
            return this.treePath;
        }

        public void run() {
            this.treePath = this.swkjtree.getSelectionPath();
        }
    }

    class NodeAdd
    extends UpdateOnEventThread {
        SwkJTree swkjtree;
        int[] iNodes = null;
        DefaultMutableTreeNode node = null;

        NodeAdd() {
        }

        void add(SwkJTree swkjtree, int[] iNodes, String nodeVal) {
            this.swkjtree = swkjtree;
            this.iNodes = iNodes;
            this.node = new DefaultMutableTreeNode(nodeVal);
            this.execOnThread();
        }

        public void run() {
            DefaultTreeModel model = (DefaultTreeModel)this.swkjtree.getModel();
            if (this.iNodes == null) {
                model.setRoot(this.node);
            } else {
                DefaultMutableTreeNode refNode = (DefaultMutableTreeNode)model.getRoot();
                for (int i = 0; i < this.iNodes.length; ++i) {
                    refNode = (DefaultMutableTreeNode)refNode.getChildAt(this.iNodes[i]);
                }
                refNode.add(this.node);
            }
        }
    }
}

