/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.GradientParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.OutlineParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TextureParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;

public class ItemNode
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new WidthParameter(), new TextureParameter(), new GradientParameter(), new FillParameter(), new OutlineParameter(), new TagsParameter(), new TransformerParameter(), new RotateParameter(), new ShearParameter(), new StateParameter(), new NodeParameter()};
    static Map parameterMap = new TreeMap();
    TextParameters textPar = TextParameters.getDefault();
    Rectangle2D rect2D = null;

    ItemNode(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.rect2D = (Rectangle2D)shape;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 2) {
            throw new SwkException("wrong # coordinates: expected 2, got " + coords.length);
        }
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        this.storeCoords[0] = coords[0];
        this.storeCoords[1] = coords[1];
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        AffineTransform aT = new AffineTransform();
        this.genGradient(aT);
    }

    public void paintShape(Graphics2D g2) {
        super.paintShape(g2);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "node";
    }

    static {
        ItemNode.initializeParameters(parameters, parameterMap);
    }
}

