/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.str;

import java.util.LinkedList;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.str.BacktrackPoint;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="str", module="Str", source="otherlibs/str/strstubs.c")
public final class Str {
    private static final long PROG = 0L;
    private static final long CPOOL = 1L;
    private static final long NORM_TABLE = 2L;
    private static final long NUM_GROUPS = 3L;
    private static final long NUM_REGISTERS = 4L;
    private static final long START_CHARS = 5L;
    private static final int CHAR = 0;
    private static final int CHARNORM = 1;
    private static final int STRING = 2;
    private static final int STRINGNORM = 3;
    private static final int CHARCLASS = 4;
    private static final int BOL = 5;
    private static final int EOL = 6;
    private static final int WORDBOUNDARY = 7;
    private static final int BEGGROUP = 8;
    private static final int ENDGROUP = 9;
    private static final int REFGROUP = 10;
    private static final int ACCEPT = 11;
    private static final int SIMPLEOPT = 12;
    private static final int SIMPLESTAR = 13;
    private static final int SIMPLEPLUS = 14;
    private static final int GOTO = 15;
    private static final int PUSHBACK = 16;
    private static final int SETMARK = 17;
    private static final int CHECKPROGRESS = 18;
    private static final int NO_GOTO = 0;
    private static final int GOTO_PREFIX_MATCH = 1;
    private static final int GOTO_BACKTRACK = 2;
    private static final int GOTO_PUSH = 3;
    private static final int GOTO_ACCEPT = 4;
    private static final int NULL = -1;
    private static final Value NULL_VALUE = Value.MINUS_ONE;
    private static final Object SLOT_GROUPS = new Object();
    private static final int END_OF_LINE = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte('\n'));
    private static final int[] RE_WORD_LETTERS = new int[]{0, 0, 0, 0, 0, 0, 255, 3, 254, 255, 255, 135, 254, 255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 127, 255, 255, 255, 127, 255};

    private Str() {
    }

    private static boolean isWordLetter(int n) {
        return (RE_WORD_LETTERS[n >> 3] >> (n & 7) & 1) != 0;
    }

    private static int opcode(int n) {
        return n & 0xFF;
    }

    private static int arg(int n) {
        return (int)(IntegerUtils.signedToUnsigned(n) >> 8);
    }

    private static int signedArg(int n) {
        return n >> 8;
    }

    private static boolean inBitSet(int[] nArray, int n) {
        return (nArray[n >> 3] >> (n & 7) & 1) != 0;
    }

    private static boolean match(Context context, Value value, int[] nArray, int n, int n2, int n3, boolean bl) throws Fatal.Exception {
        int n4;
        int n5 = n2;
        int n6 = value.get(3L).asCastedInt();
        ReGroup[] reGroupArray = new ReGroup[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            reGroupArray[n4] = new ReGroup();
        }
        n4 = value.get(4L).asCastedInt();
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = -1;
        }
        context.getCodeState().registerSlot(SLOT_GROUPS, reGroupArray);
        BacktrackPoint backtrackPoint = null;
        int n7 = 0;
        LinkedList<BacktrackPoint> linkedList = new LinkedList<BacktrackPoint>();
        Value value2 = value.get(1L);
        Value value3 = value.get(2L);
        reGroupArray[0].idxStart = n5;
        block34: while (true) {
            int n8 = value.get0().get(n7++).asCastedInt();
            int n9 = 0;
            block0 : switch (Str.opcode(n8)) {
                case 0: {
                    if (n5 == n3) {
                        n9 = 1;
                        break;
                    }
                    if (nArray[n5] != Str.arg(n8)) {
                        n9 = 2;
                        break;
                    }
                    ++n5;
                    break;
                }
                case 1: {
                    if (n5 == n3) {
                        n9 = 1;
                        break;
                    }
                    if (value3.getUnsignedByte(nArray[n5]) != Str.arg(n8)) {
                        n9 = 2;
                        break;
                    }
                    ++n5;
                    break;
                }
                case 2: {
                    int n10;
                    int[] nArray3 = value2.get(Str.arg(n8)).getUnsignedBytes();
                    int n11 = 0;
                    int n12 = n10 = n11 < nArray3.length ? nArray3[n11++] : 0;
                    while (n10 != 0) {
                        if (n5 == n3) {
                            n9 = 1;
                            break block0;
                        }
                        if (n10 != nArray[n5]) {
                            n9 = 2;
                            break block0;
                        }
                        ++n5;
                        n10 = n11 < nArray3.length ? nArray3[n11++] : 0;
                    }
                    break;
                }
                case 3: {
                    int n10;
                    int[] nArray4 = value2.get(Str.arg(n8)).getUnsignedBytes();
                    int n13 = 0;
                    int n14 = n10 = n13 < nArray4.length ? nArray4[n13++] : 0;
                    while (n10 != 0) {
                        if (n5 == n3) {
                            n9 = 1;
                            break block0;
                        }
                        if (n10 != value3.getUnsignedByte(nArray[n5])) {
                            n9 = 2;
                            break block0;
                        }
                        ++n5;
                        n10 = n13 < nArray4.length ? nArray4[n13++] : 0;
                    }
                    break;
                }
                case 4: {
                    if (n5 == n3) {
                        n9 = 1;
                        break;
                    }
                    int n10 = nArray[n5];
                    if (!Str.inBitSet(value2.get(Str.arg(n8)).getUnsignedBytes(), nArray[n5])) {
                        n9 = 2;
                        break;
                    }
                    ++n5;
                    break;
                }
                case 5: {
                    if (n5 <= n || nArray[n5 - 1] == END_OF_LINE) break;
                    n9 = 2;
                    break;
                }
                case 6: {
                    if (n5 >= n3 || nArray[n5] == END_OF_LINE) break;
                    n9 = 2;
                    break;
                }
                case 7: {
                    if (n5 == n) {
                        if (n5 == n3) {
                            n9 = 1;
                            break;
                        }
                        if (Str.isWordLetter(nArray[n5])) break;
                        n9 = 2;
                        break;
                    }
                    if (n5 == n3) {
                        if (Str.isWordLetter(nArray[n5 - 1])) break;
                        n9 = 2;
                        break;
                    }
                    if (Str.isWordLetter(nArray[n5 - 1]) != Str.isWordLetter(nArray[n5])) break;
                    n9 = 2;
                    break;
                }
                case 8: {
                    int n15 = Str.arg(n8);
                    ReGroup reGroup = reGroupArray[n15];
                    backtrackPoint = BacktrackPoint.makeUndo(n15 << 2 | 1, reGroup.idxStart);
                    reGroup.idxStart = n5;
                    n9 = 3;
                    break;
                }
                case 9: {
                    int n16 = Str.arg(n8);
                    ReGroup reGroup = reGroupArray[n16];
                    backtrackPoint = BacktrackPoint.makeUndo(n16 << 2 | 2, reGroup.idxEnd);
                    reGroup.idxEnd = n5;
                    n9 = 3;
                    break;
                }
                case 10: {
                    ReGroup reGroup = reGroupArray[Str.arg(n8)];
                    if (reGroup.idxStart == -1 || reGroup.idxEnd == -1) {
                        n9 = 2;
                        break;
                    }
                    for (int i = reGroup.idxStart; i < reGroup.idxEnd; ++i) {
                        if (n5 == n3) {
                            n9 = 1;
                            break block0;
                        }
                        if (nArray[i] != nArray[n5]) {
                            n9 = 2;
                            break block0;
                        }
                        ++n5;
                    }
                    break;
                }
                case 11: {
                    n9 = 4;
                    break;
                }
                case 12: {
                    int[] nArray5 = value2.get(Str.arg(n8)).getUnsignedBytes();
                    if (n5 >= n3) break;
                    int n10 = nArray[n5];
                    if (!Str.inBitSet(nArray5, nArray[n5])) break;
                    ++n5;
                    break;
                }
                case 13: {
                    int n10;
                    int[] nArray6 = value2.get(Str.arg(n8)).getUnsignedBytes();
                    while (n5 < n3 && Str.inBitSet(nArray6, nArray[n5])) {
                        n10 = nArray[n5];
                        ++n5;
                    }
                    if (n5 >= n3) break;
                    n10 = nArray[n5];
                    break;
                }
                case 14: {
                    int[] nArray7 = value2.get(Str.arg(n8)).getUnsignedBytes();
                    if (n5 == n3) {
                        n9 = 1;
                        break;
                    }
                    int n10 = nArray[n5];
                    if (!Str.inBitSet(nArray7, nArray[n5])) {
                        n9 = 2;
                        break;
                    }
                    ++n5;
                    while (n5 < n3 && Str.inBitSet(nArray7, nArray[n5])) {
                        n10 = nArray[n5];
                        ++n5;
                    }
                    if (n5 >= n3) break;
                    n10 = nArray[n5];
                    break;
                }
                case 15: {
                    n7 += Str.signedArg(n8);
                    break;
                }
                case 16: {
                    backtrackPoint = BacktrackPoint.makePos(n7 + Str.signedArg(n8), n5);
                    n9 = 3;
                    break;
                }
                case 17: {
                    int n17 = Str.arg(n8);
                    backtrackPoint = BacktrackPoint.makeUndo(n17 << 2 | 3, nArray2[n17]);
                    nArray2[n17] = n5;
                    n9 = 3;
                    break;
                }
                case 18: {
                    if (nArray2[Str.arg(n8)] != n5) break;
                    n9 = 2;
                    break;
                }
                default: {
                    Fatal.raise("impossible case in re_match");
                }
            }
            block40: while (true) {
                if (n9 == 0) continue block34;
                switch (n9) {
                    case 3: {
                        linkedList.add(0, backtrackPoint);
                        n9 = 0;
                        continue block40;
                    }
                    case 1: {
                        if (bl) {
                            n9 = 4;
                            continue block40;
                        }
                        n9 = 2;
                        continue block40;
                    }
                    case 2: {
                        n9 = 0;
                        block41: while (true) {
                            if (linkedList.size() == 0) {
                                return false;
                            }
                            BacktrackPoint backtrackPoint2 = (BacktrackPoint)linkedList.remove(0);
                            if (backtrackPoint2.isPos()) {
                                n7 = backtrackPoint2.getPc();
                                n5 = backtrackPoint2.getTxt();
                                continue block40;
                            }
                            int n18 = backtrackPoint2.getLoc();
                            int n19 = backtrackPoint2.getVal();
                            switch (n18 & 3) {
                                case 1: {
                                    reGroupArray[n18 >> 2].idxStart = n19;
                                    continue block41;
                                }
                                case 2: {
                                    reGroupArray[n18 >> 2].idxEnd = n19;
                                    continue block41;
                                }
                                case 3: {
                                    nArray2[n18 >> 2] = n19;
                                    continue block41;
                                }
                            }
                            if (!$assertionsDisabled) break;
                        }
                        throw new AssertionError((Object)"invalid backtrack tag");
                    }
                    case 4: {
                        linkedList.clear();
                        reGroupArray[0].idxEnd = n5;
                        return true;
                    }
                }
                if (!$assertionsDisabled) break block34;
            }
            break;
        }
        throw new AssertionError((Object)"invalid goto");
    }

    private static Value allocGroups(Context context, Value value) {
        ReGroup[] reGroupArray = (ReGroup[])context.getCodeState().getSlot(SLOT_GROUPS);
        int n = value.get(3L).asCastedInt();
        Value value2 = Value.createBlock(0, n * 2);
        for (int i = 0; i < n; ++i) {
            ReGroup reGroup = reGroupArray[i];
            if (reGroup.idxStart == -1 || reGroup.idxEnd == -1) {
                value2.set(2 * i, NULL_VALUE);
                value2.set(2 * i + 1, NULL_VALUE);
                continue;
            }
            value2.set(2 * i, Value.createLong(reGroup.idxStart));
            value2.set(2 * i + 1, Value.createLong(reGroup.idxEnd));
        }
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_string_match(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Context context = CurrentContext.CONTEXT;
        int[] nArray = value2.getUnsignedBytes();
        boolean bl = false;
        int n = value3.asBoundedInt();
        int n2 = nArray.length;
        if (n < 0 || n > n2) {
            Fail.invalidArgument("Str.string_match");
        }
        if (Str.match(context, value, nArray, 0, n, n2, false)) {
            return Str.allocGroups(context, value);
        }
        return context.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_partial_match(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Context context = CurrentContext.CONTEXT;
        int[] nArray = value2.getUnsignedBytes();
        boolean bl = false;
        int n = value3.asBoundedInt();
        int n2 = nArray.length;
        if (n < 0 || n > n2) {
            Fail.invalidArgument("Str.string_partial_match");
        }
        if (Str.match(context, value, nArray, 0, n, n2, true)) {
            return Str.allocGroups(context, value);
        }
        return context.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_search_forward(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Context context = CurrentContext.CONTEXT;
        int[] nArray = value2.getUnsignedBytes();
        boolean bl = false;
        int n = value3.asBoundedInt();
        int n2 = nArray.length;
        if (n < 0 || n > n2) {
            Fail.invalidArgument("Str.search_forward");
        }
        if (value.get(5L) == NULL_VALUE) {
            do {
                if (!Str.match(context, value, nArray, 0, n, n2, false)) continue;
                return Str.allocGroups(context, value);
            } while (++n <= n2);
            return context.getCodeState().getAtom(0);
        }
        int[] nArray2 = value.get(1L).get(value.get(5L).asLong()).getUnsignedBytes();
        while (true) {
            if (n < n2 && nArray2[nArray[n]] == 0) {
                ++n;
                continue;
            }
            if (Str.match(context, value, nArray, 0, n, n2, false)) {
                return Str.allocGroups(context, value);
            }
            if (++n > n2) break;
        }
        return context.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Str.regexp", "string", "int"}, returnType="int array")
    public static Value re_search_backward(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Context context = CurrentContext.CONTEXT;
        int[] nArray = value2.getUnsignedBytes();
        boolean bl = false;
        int n = value3.asBoundedInt();
        int n2 = nArray.length;
        if (n < 0 || n > n2) {
            Fail.invalidArgument("Str.search_backward");
        }
        if (value.get(5L) == NULL_VALUE) {
            do {
                if (!Str.match(context, value, nArray, 0, n, n2, false)) continue;
                return Str.allocGroups(context, value);
            } while (--n >= 0);
            return context.getCodeState().getAtom(0);
        }
        int[] nArray2 = value.get(1L).get(value.get(5L).asLong()).getUnsignedBytes();
        while (true) {
            if (n > 0 && nArray2[nArray[n]] == 0) {
                --n;
                continue;
            }
            if (Str.match(context, value, nArray, 0, n, n2, false)) {
                return Str.allocGroups(context, value);
            }
            if (--n < 0) break;
        }
        return context.getCodeState().getAtom(0);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int array", "string"}, returnType="string")
    public static Value re_replacement_text(Value value, Value value2, Value value3) throws Fail.Exception {
        int n;
        int n2;
        char c;
        int n3 = 0;
        String string = value.asString();
        int n4 = 0;
        int n5 = string.length();
        String string2 = value3.asString();
        block8: while (n5 > 0) {
            char c2 = string.charAt(n4++);
            --n5;
            if (c2 != '\\') {
                ++n3;
                continue;
            }
            if (n5 == 0) {
                Fail.failWith("Str.replace: illegal backslash sequence");
            }
            c2 = string.charAt(n4++);
            --n5;
            switch (c2) {
                case '\\': {
                    ++n3;
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    c = (c2 - 48) * 2;
                    if ((long)c >= value2.sizeValues()) {
                        Fail.failWith("Str.replace: reference to unmatched group");
                    }
                    n2 = value2.get(c).asCastedInt();
                    n = value2.get(c + '\u0001').asCastedInt();
                    if (n2 == -1) {
                        Fail.failWith("Str.replace: reference to unmatched group");
                    }
                    n3 += n - n2;
                    continue block8;
                }
            }
            n3 += 2;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        n4 = 0;
        n5 = string.length();
        block9: while (n5 > 0) {
            c = string.charAt(n4++);
            --n5;
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            c = string.charAt(n4++);
            --n5;
            switch (c) {
                case '\\': {
                    stringBuilder.append('\\');
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n2 = 2 * (c - 48);
                    n = value2.get(n2).asCastedInt();
                    int n6 = value2.get(n2 + 1).asCastedInt();
                    n3 = n6 - n;
                    stringBuilder.append(string2.substring(n, n3));
                    continue block9;
                }
            }
            stringBuilder.append('\\');
            stringBuilder.append(c);
        }
        return Value.createString(stringBuilder.toString());
    }

    private static final class ReGroup {
        int idxStart = -1;
        int idxEnd = -1;

        private ReGroup() {
        }
    }
}

