/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.values.Value;

public final class Primitives2Marshalled
extends AbstractPrimitivesConverter {
    private final FileOutputStream out;
    private final List<Value> values;

    private Primitives2Marshalled(String string, String string2) throws IOException {
        super(string, null);
        assert (string2 != null) : "null f";
        this.out = new FileOutputStream(string2);
        this.values = new ArrayList<Value>();
    }

    @Override
    protected void beforeWalk() {
        this.values.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void visitClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            PrimitiveProvider primitiveProvider = clazz.getAnnotation(PrimitiveProvider.class);
            if (primitiveProvider == null) return;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Value[]> arrayList2 = new ArrayList<Value[]>();
            ArrayList<Value> arrayList3 = new ArrayList<Value>();
            for (Object object : clazz.getDeclaredMethods()) {
                Primitive primitive = ((Method)object).getAnnotation(Primitive.class);
                if (primitive == null) continue;
                arrayList.add(((Method)object).getName());
                arrayList2.add(Primitives2Marshalled.convertTypeArray(((Method)object).getParameterTypes(), primitive.parameterTypes()));
                arrayList3.add(Primitives2Marshalled.convertType(((Method)object).getReturnType(), primitive.returnType()));
            }
            int n = arrayList.size();
            Value value = Value.createBlock(0, n);
            int n2 = 0;
            while (true) {
                Object object;
                if (n2 >= n) {
                    this.values.add(Value.createBlock(0, Value.createString(string), value));
                    return;
                }
                object = Value.createBlock(0, Value.createString((String)arrayList.get(n2)), Value.createBlock(0, (Value[])arrayList2.get(n2)), (Value)arrayList3.get(n2));
                value.set(n2, (Value)object);
                ++n2;
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return;
        }
        catch (Throwable throwable) {
            PrintStream printStream = System.err;
            printStream.printf("error: exception while processing class '%s'\n", string);
            throwable.printStackTrace(printStream);
            System.exit(1);
        }
    }

    @Override
    protected void afterWalk() {
    }

    private void write() throws IOException {
        int n = this.values.size();
        Value value = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value.set(i, this.values.get(i));
        }
        try {
            ContextWithoutRuntimeLock contextWithoutRuntimeLock = new ContextWithoutRuntimeLock(Parameters.defaultByteCodeParameters(), false, new File("."));
            this.out.write(MarshalExtern.externValue(contextWithoutRuntimeLock, value, Value.EMPTY_LIST));
        }
        catch (Fail.Exception exception) {
            throw new IOException("error in marshalling");
        }
    }

    private static Value convertType(Class<?> clazz, String string) {
        assert (clazz != null) : "null t";
        assert (string != null) : "null a";
        if (Void.TYPE.equals(clazz)) {
            return Value.ZERO;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Value.ONE;
        }
        if (Long.TYPE.equals(clazz)) {
            if ("int".equals(string)) {
                return Value.TWO;
            }
            if ("int64".equals(string)) {
                return Value.THREE;
            }
            if ("nativeint".equals(string)) {
                return Value.FOUR;
            }
            PrintStream printStream = System.err;
            printStream.printf("error: cannot convert Java type '%s' with annotation '%s'\n", clazz.toString(), string);
            System.exit(1);
            return null;
        }
        if (Double.TYPE.equals(clazz)) {
            return Value.FIVE;
        }
        if (Value.class.equals(clazz)) {
            return Value.SIX;
        }
        PrintStream printStream = System.err;
        printStream.printf("error: cannot convert Java type '%s'\n", clazz.toString());
        System.exit(1);
        return null;
    }

    private static Value[] convertTypeArray(Class<?>[] classArray, String[] stringArray) {
        assert (classArray != null) : "null t";
        assert (stringArray != null) : "null a";
        assert (classArray.length == stringArray.length) : "t and a should have the same length";
        int n = classArray.length;
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Primitives2Marshalled.convertType(classArray[i], stringArray[i]);
        }
        return valueArray;
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        if (stringArray.length == 2) {
            try {
                Primitives2Marshalled primitives2Marshalled = new Primitives2Marshalled(stringArray[0], stringArray[1]);
                primitives2Marshalled.walkFileTree();
                primitives2Marshalled.write();
            }
            catch (IOException iOException) {
                printStream.printf("i/o error: %s\n", iOException.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            printStream.println("error: a path, and a file should be provided");
            System.exit(1);
        }
    }
}

